package gov.va.caret.model.support.occ;


import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.StiPtWrapper;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorSe;
import gov.va.caret.model.impl.WorSeImpl;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.WorSeLocalServiceUtil;
import gov.va.caret.util.Toolbox;

public class StipendConfig extends StiPtWrapper {

	WorSe workItemStep = null;
	
	public StipendConfig(StiPt StiPt) {
		super(StiPt);
	}


	//Caregivers Effective Date is always the Application Received Date
	//The date the Application was received
	//AKA Effective Date.  Approval Date must be after applicationReceivedDate
	public Date getEffectiveDate() {
		return super.getStipendStartDate();
	}

	
	@Override
    public void persist() throws com.liferay.portal.kernel.exception.SystemException {
        super.persist();
        if ( workItemStep != null ){
        	workItemStep.persist();
		}
    }

	//Used only during save...
	public void setFields( Date effectiveDate, VcgSupport vcg, WorIm worIm, ServiceContext sc, String oldVal, String newVal ) throws ApplicationWorkFlowException {
		BlsRe bls = BlsReLocalServiceUtil.findLatestBlsByZip( vcg.getVeteran().getZip() );
		setBlsRateHourly( String.valueOf( bls.getH75() ) );
		setTier( String.valueOf( vcg.getTierLevel() ) );
		setTierHours( String.valueOf( getTierLevelMonthlyHours( getTier() )  ) );
		setWorImId( worIm.getWorImId() );
		setStipendStatus( worIm.getType() + StringPool.COLON + worIm.getStatus() );

		setStipendStartDate( effectiveDate );
		setStipendApprovedDate( sc.getCreateDate() );
		
		BigDecimal monthlyRate= new BigDecimal( bls.getH75() ).multiply( getTierLevelMonthlyHours( vcg.getTierLevel() ) );
		monthlyRate = new BigDecimal( String.valueOf( monthlyRate.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		setMonthlyPayment( monthlyRate.toString() );
		setICN( vcg.getPrimary().getICN() );
		setVcgId( vcg.getVcgId() );
		
		workItemStep = new WorSeImpl();
		workItemStep.setWorImId( worIm.getWorImId() );
		workItemStep.setCreationDate( sc.getCreateDate() );
		workItemStep.setUserId( sc.getUserId() );
		int count = WorSeLocalServiceUtil.getCount ( worIm.getWorImId() );
		workItemStep.setStepNumber(count+1);
		workItemStep.setOldStep( oldVal );
		workItemStep.setStep( newVal );
	}

	public static BigDecimal getTierLevelMonthlyHours( String level ){
		if ( Toolbox.isEmpty(level) ){
			return BigDecimal.ZERO;
		}
		return getTierLevelMonthlyHours( Integer.valueOf(level) );
	}
	
	public static BigDecimal getTierLevelMonthlyHours( int level ){
		switch( Integer.valueOf( level ) ){
		case 1: return CalculationInfo.TIER_1_MONTH_HOURS;
		case 2: return CalculationInfo.TIER_2_MONTH_HOURS;
		case 3: return CalculationInfo.TIER_3_MONTH_HOURS;
		default: return BigDecimal.ZERO; 
		}
	}


}
