package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;


public class Reinstatement extends CalculationWrapper {

	
	
	private BigDecimal dailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
//	private BigDecimal monthlyAmount = null;		//1296.30 [Tier Level Monthly Hours] * [Local Hourly Wage]
	private BigDecimal backPay = null;				//[Number of Retro Months] * [Monthly Amount]

	public Reinstatement(WorIm workItem, StiPt config, int month, int year ) {
		super(workItem, config, month, year);
	}
	
	public int getPaymentMonth() {
		return stipendMonth;
	}
	
	public int getPaymentYear() {
		return stipendYear;
	}
	
	public BigDecimal getBackPayAmount(){
		if ( backPay == null ){
			backPay = new BigDecimal( getRetroactiveMonths() ).multiply( getMonthlyRate() );
		}
		return backPay;
	}
	
	BigDecimal getTotalStipend(){
		if ( totalStipend == null ){
			totalStipend = getMonthlyRate().add( getProratedAmount() ).add( getBackPayAmount() );
			totalStipend = new BigDecimal( String.valueOf( totalStipend.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		}
		return totalStipend;
	}
	
	public BigDecimal getMonthlyRate (  ) {
		BigDecimal monthlyAmount = new BigDecimal( config.getBlsRateHourly() ).multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) );
		monthlyAmount = new BigDecimal( String.valueOf( monthlyAmount.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		return monthlyAmount;
	}
	
	
	
	public String getProratedDate(){
		return Toolbox.formatDate( config.getStipendStartDate() );
	}
	
	public double getTotalDays(  ) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
	}
	
	public BigDecimal getProratedAmount(){
		return new BigDecimal( getTotalDays() ).multiply( getDailyRate() );
	}
	
	public int getRetroactiveMonths( ){
		int totalMonths = 0;
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		while ( calendar.getTime().before( getPaymentMonthDate(  ) ) ) {
			int days = calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
			if ( days == calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) ){
				totalMonths++;
			}
			calendar.set( Calendar.DAY_OF_MONTH, 1);
			if ( calendar.get(Calendar.MONTH ) == Calendar.DECEMBER ){
				calendar.roll( Calendar.YEAR, true );
				calendar.roll( Calendar.MONTH, true );
			} else {
				calendar.roll( Calendar.MONTH, true );
			}
		}
		return totalMonths;
	}
	
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			dailyRate = new BigDecimal( config.getBlsRateHourly() ).multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}
//
//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig config = new StipendConfig( 3, 18.11, format.parse("01/14/2017") );
//		System.out.println( new Reinstatement( config, Calendar.FEBRUARY, 2017 ) );
//	}

	public String toString () {
		return  "Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n     Reinstatement Date: " + formatDate( config.getStipendStartDate() ) +
				"\n          Tier Level of: " + config.getTier() + 
				"\n Total Monthly Hours of: " + StipendConfig.getTierLevelMonthlyHours( config.getTier() ) + 
				"\n   Local hourly Rate of: " + config.getBlsRateHourly() +
				"\n          Daily Rate of: " + getDailyRate() +
				"\n        Retro Months of: " + getRetroactiveMonths(  ) +
				"\n      Monthly Amount of: " + getMonthlyRate(  ) +
				"\n          Total Days of: " + getTotalDays(  ) +
				"\n           Payment owed: " + getTotalStipend(  ) +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}
}

