package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;


public class InitialPayment extends CalculationWrapper {

	static DateFormat format = new SimpleDateFormat("MM/dd/yyyy");
	
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
	private BigDecimal backPay = null;				//[Number of Retro Months] * [Monthly Amount]

	public InitialPayment(WorIm workItem, StiPt config, int month, int year ) {
		super(workItem, config, month, year);
	}

	public BigDecimal getBackPayAmount(){
		if ( backPay == null ){
			backPay = new BigDecimal( getRetroactiveMonths() ).multiply( getMonthlyRate() );
		}
		return backPay;
	}
	
	public BigDecimal getFinalAmount(){
		if ( totalStipend == null ){
			Calendar lastDayStipendStartMonth = Calendar.getInstance();
			lastDayStipendStartMonth.setTime( config.getStipendStartDate() );
			
			if ( Calendar.DECEMBER == lastDayStipendStartMonth.get( Calendar.MONTH ) ){
				lastDayStipendStartMonth.roll( Calendar.YEAR, true);
			}
			lastDayStipendStartMonth.set( Calendar.DAY_OF_MONTH, lastDayStipendStartMonth.getActualMaximum(Calendar.DAY_OF_MONTH) );
//			lastDayStipendStartMonth.roll( Calendar.DAY_OF_YEAR, true);
			
			if ( lastDayStipendStartMonth.getTime().after( getPaymentDate() ) ){
				totalStipend = getProratedAmount().add( getBackPayAmount() );
			} else {
				totalStipend = getMonthlyRate().add( getProratedAmount() ).add( getBackPayAmount() );
			}
			totalStipend = new BigDecimal( String.valueOf( totalStipend.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		}
		return totalStipend;
	}
	
	public double getTotalDays(  ) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );//effective date
		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
	}
	
	public BigDecimal getProratedAmount(){  //getProratedAmount()
		return new BigDecimal( getTotalDays() ).multiply( getDailyRate() );
	}
	
	public int getRetroactiveMonths( ){
		int totalMonths = 0;
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		Calendar paymentMonth = Calendar.getInstance();
		paymentMonth.setTime( getPaymentMonthDate(  ) );
		Calendar currentMonth = Calendar.getInstance();
		while ( calendar.getTime().before( getPaymentMonthDate(  ) ) ) {
			if ( calendar.get( Calendar.MONTH ) < paymentMonth.get( Calendar.MONTH ) && calendar.get( Calendar.MONTH ) != currentMonth.get( Calendar.MONTH )-1 ){
				totalMonths++;
			}
			if ( calendar.get(Calendar.MONTH ) == Calendar.DECEMBER ){
				calendar.roll( Calendar.YEAR, true );
				calendar.roll( Calendar.MONTH, true );
			} else {
				calendar.roll( Calendar.MONTH, true );
			}
			calendar.set( Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH) );
		}
		return totalMonths;
	}
	
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			dailyRate = StipendConfig.getTierLevelMonthlyHours( config.getTier() ).multiply( new BigDecimal( config.getBlsRateHourly() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}
	

	public boolean isRecoupable(){
		return false;
	}

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig config = new StipendConfig( 2, 11.92, format.parse("10/15/2016") );
//		System.out.println( new InitialPayment( config, Calendar.FEBRUARY, 2017 ) );
//	}

	public String toString () {
		return  "Stipend Payment Date: " + format.format( getPaymentDate() ) + 
				"\n        With Begin Date: " + format.format( config.getStipendStartDate() ) +
				"\n          Tier Level of: " + config.getTier() + 
				"\n Total Monthly Hours of: " + StipendConfig.getTierLevelMonthlyHours( config.getTier() ) + 
				"\n   Local hourly Rate of: " + config.getBlsRateHourly() +
				"\n          Daily Rate of: " + getDailyRate() +
				"\n        Retro Months of: " + getRetroactiveMonths(  ) +
				"\n          Total Days of: " + getTotalDays(  ) +
				"\n           Payment owed: " + getFinalAmount(  ) +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}
}

