package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;

public class CalculationWrapper implements CalculationInfo {

	BigDecimal defaultValue = BigDecimal.ZERO;
	
	protected WorIm workItem;
	protected StiPt config;
	protected int stipendMonth;
	protected int stipendYear;
	protected BigDecimal dailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	protected BigDecimal monthlyRate = null;		//1296.30 [Tier Level Monthly Hours] * [Local Hourly Wage]
	
	public CalculationWrapper(WorIm workItem, StiPt config, int month, int year ) {
		this.workItem = workItem;
		this.config = config;
		this.stipendMonth = month;
		this.stipendYear = year;
	}
	
	public int getPaymentMonth() {
		return stipendMonth;
	}
	
	public int getPaymentYear() {
		return stipendYear;
	}
	
	public Date getPaymentMonthDate(  ){
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		calendar.set( Calendar.MONTH, getPaymentMonth() );
		calendar.set( Calendar.YEAR, getPaymentYear() );
		calendar.set( Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH) );
		return calendar.getTime();
	}
	
	public Date getPaymentDate( ){
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		calendar.set( Calendar.MONTH, getPaymentMonth() );
		calendar.set( Calendar.YEAR, getPaymentYear() );
		if ( Calendar.DECEMBER == calendar.get( Calendar.MONTH ) ){
			calendar.roll( Calendar.YEAR, true);
		}
		calendar.set( Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH) );
		calendar.roll( Calendar.DAY_OF_YEAR, true);
		return calendar.getTime();
	}
	
	@Override
	public String getProratedDate() {
		return null;
	}
	
	@Override
	public int getRetroactiveMonths() {
		return 0;
	}

	@Override
	public BigDecimal getMonthlyRecurringAmount() {
		return getMonthlyRate();
	}
	
	public StiPt getStipendPaymentConfig (){
		return config;
	}

	public BigDecimal getMonthlyRate (  ) {
		return new BigDecimal( config.getMonthlyPayment() );
	}
	
//	public BigDecimal getLocalHourlyWage (  ) {
//		return new BigDecimal( config.getBlsRateHourly() );
//	}
//	
//	public BigDecimal getTierLevelMonthlyHours (  ) {
//		return new BigDecimal( config.getTierHours() );
//	}

	@Override
	public BigDecimal getBackPayAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getFinalAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getRecoupmentAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getProratedAmount() {
		return defaultValue;
	}
	
	@Override
	public BigDecimal getHourlyRate() {
		return new BigDecimal( config.getBlsRateHourly() );
	}

	@Override
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			dailyRate = new BigDecimal( config.getBlsRateHourly() ).multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}

	
	public boolean isCalculationWork(){
		return true;
	}
	
	public boolean isCalculationChange(){
		return false;
	}
	
	public boolean isRecoupable(){
		return true;
	}
	
	public String formatDate( Date date ){
		return Toolbox.formatDate(date);
	}
}

