package gov.va.caret.model.support.occ;

import java.math.BigDecimal;

import com.liferay.util.portlet.PortletProps;

import gov.va.caret.model.StiPt;

public interface CalculationInfo {
/*
a.	Monthly recurring amount 
b.	Back pay amount
c.	Final payment amount 
d.	Recoupment amount
e.	Monthly rate
g.	Daily rate
h.	Prorated amount and dates
i.	Number of retroactive months

f.	Hourly rate
j.	Veterans zip code
k.	Transaction date (application approval date)
l.	Tier level
 */
	BigDecimal MONTH_MULTIPLIER = new BigDecimal( PortletProps.get("bls.payment.weeks") );
	BigDecimal TIER_1_MONTH_HOURS = MONTH_MULTIPLIER.multiply( new BigDecimal( Integer.getInteger( PortletProps.get( "tier1.hours"), 10 ) ) );
	BigDecimal TIER_2_MONTH_HOURS = MONTH_MULTIPLIER.multiply( new BigDecimal( Integer.getInteger( PortletProps.get( "tier2.hours"), 25 ) ) );
	BigDecimal TIER_3_MONTH_HOURS = MONTH_MULTIPLIER.multiply( new BigDecimal( Integer.getInteger( PortletProps.get( "tier3.hours"), 40 ) ) );
	public BigDecimal getMonthlyRecurringAmount();
	public BigDecimal getBackPayAmount();
	public BigDecimal getFinalAmount();
	public BigDecimal getRecoupmentAmount();
	public BigDecimal getProratedAmount();
	public BigDecimal getMonthlyRate();
	public BigDecimal getDailyRate();
	public BigDecimal getHourlyRate();
	public String getProratedDate();
	public int getRetroactiveMonths();
	public boolean isCalculationChange();
	public boolean isRecoupable();
	public boolean isCalculationWork();
	public StiPt getStipendPaymentConfig ();
}
