package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.liferay.util.portlet.PortletProps;

import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.WorkName;

public enum WorkType {
	ONLINE_APP(getDouble(PortletProps.get("onlineApp.due.days"), 1.0 ), true, true),
	CSC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true, true),
	HEC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true, true),
	FACILITY_APP(getDouble(PortletProps.get("facilityApp.due.days"), 1.0 )),
	SOC( getDouble(PortletProps.get("soc.due.days"), 25.0 )),
	SOC_FOLLOWUP( getDouble(PortletProps.get("soc.followup.due.days"), -1.0 )),
	CESP(getDouble(PortletProps.get("cesp.due.days"), -1.0 )),
	CESP_CSC(getDouble(PortletProps.get("cesp.csc.due.days"), -1.0 )),
	REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	HEC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	HRC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), false, true),
	CSL_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	CALL_REFERRAL(getDouble(PortletProps.get("callReferral.due.days"), 5.0 ), true, false),
	HOME_VISIT(getDouble(PortletProps.get("homeVisit.due.days"), 10.0 ), true, false),	
	APP_DELAY(getDouble(PortletProps.get("visn.waiver.days"), 121.0 ), true, false, getDouble( PortletProps.get("visn.approval.days"), 20) ),
	DELAY_REVIEWED(getDouble(PortletProps.get("visn.approval.days"), 20.0 ), true, false),
	CSC_WAIVER(getDouble(PortletProps.get("csc.waiver.days"), 90.0 )),
	APPEAL(getDouble(PortletProps.get("csc.appeal.days"), -1 ), true, true),
//	CORRECTION_Q(WorkName.CORRECTION_Q, -1),
	FAILED_TIU_NOTE(-1, true, false),
	TIU_NOTE_REWRITE(-1, true, false),
	CBOPC_WI(-1),   //for New Application approved, write TIU Note
	VENDOR_CREATE_HOLD( WorkName.HELD_PAYMENT, true),
	VENDOR_UPDATE_HOLD( WorkName.HELD_PAYMENT, true),
	VENDOR_CREATE(WorkName.VENDOR_CREATE, true),
	VENDOR_UPDATE(WorkName.VENDOR_UPDATE, true),
	// VENDOR_INSURANCE_UPDATE(getDouble(PortletProps.get("insurance.update.days"), -1.0 )), 
	DISPOSITION_UPDATE(-1),
	APPROVED_DISPOSITION(WorkName.APPROVED_DISPOSITION, true),
	REVOKED_DISPOSITION(WorkName.REVOKED_DISPOSITION, true),
	REINSTATED_DISPOSITION(WorkName.REINSTATED_DISPOSITION, true),
//	INSURANCE_UPDATE(-1), 
	TIER_UPDATE(WorkName.TIER_UPDATE, true), 
	ADDRESS_CHANGE(WorkName.INFO_CHANGE, true),
	VCG_TRANSFER(-1), 
	C_INFO_CHANGE(WorkName.INFO_CHANGE, false),
	V_INFO_CHANGE(WorkName.INFO_CHANGE, false),
	VCG_INFO_CHANGE(WorkName.INFO_CHANGE, false),
	PII_CHANGE(WorkName.INFO_CHANGE, false),
	NAME_CHANGE(WorkName.INFO_CHANGE, false),
	INSURANCE_CHANGE(WorkName.INSURANCE_CHANGE, false),
	FACILITY_CHANGE(-1),
	GENERAL_CG_ASSIGNMENT(-1),
	DEATH_NOTIFICATION(-1);
	
	double days;
	double expires = -1;
	int dayRule = TYPE_CALENDAR_DAYS;
	long queId = 0;
	boolean filterRegistered = false;
	boolean isDocType = false;
	public WorkName workName;
	
	public static final long DUPLICATE_APPLICATION_CODE = -1;
	public static final long INVALID_APPLICATION_CODE = -2;
	public static final int TYPE_CALENDAR_DAYS = 0;
	public static final int TYPE_BUSINESS_DAYS = 1;

	
	WorkType( double days, int type, boolean filterRegistered, boolean isDocType ){
		this( days, filterRegistered, isDocType );
		this.dayRule = type;
	}
	WorkType( double days, boolean filterRegistered, boolean isDocType ){
		this.isDocType = isDocType;
		this.days = days;
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( double days, boolean filterRegistered, boolean isDocType, double expiration  ){
		this.isDocType = isDocType;
		this.days = days;
		this.filterRegistered = filterRegistered;
		this.expires = expiration;
	}
	
	WorkType( WorkName workName, boolean filterRegistered ){
		this.workName = workName;
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( double days ){
		this.days = days;
	}

	private static double getDouble(String string, double d) {
		if ( string == null || string.isEmpty() ){
			return d;
		}
		try{
			return Double.valueOf(string);
		} catch ( NumberFormatException nfe ){}
		return d;
	}
	
	public Date getExpirationDate(Date currDate) {
		if ( dayRule == TYPE_BUSINESS_DAYS ) {
			return getBusinessExpiresDate(currDate);
		}
		if ( expires == -1 ){
			return null;
		}
		return Toolbox.adjustDate(expires, currDate, true);
	}

	public Date getDueDate(Date createDate) {
		if ( dayRule == TYPE_BUSINESS_DAYS ) {
			return getBusinessDueDate(createDate);
		}
		if ( days == -1 ){
			return null;
			//return createDate;
		}
		return Toolbox.adjustDate(days, createDate, true);
	}
	
	public Date getBusinessDueDate(Date startDate)
	{
		if ( days == -1 ){
			return null;
		}else{
			return Toolbox.adjustBusinessDate(days, startDate, true);			
		}
	}
	
	public Date getBusinessExpiresDate(Date startDate){
		if ( expires == -1 ){
			return null;
		}else{
			return Toolbox.adjustBusinessDate(expires, startDate, true);			
		}
	}
	
	public boolean isDocType(){
		return isDocType;
	}
	
	public static List<WorkType> getFilterRegistered(){
		List<WorkType> list = new ArrayList<WorkType>();
		for ( WorkType workType: WorkType.values() ){
			if ( workType.filterRegistered ){
				list.add(workType);
			}
		}
		Collections.sort(list);
		return list;
	}
	
}