package gov.va.caret.model.support;

import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Crypto;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.VendrWrapper;
import gov.va.caret.model.impl.CryptoImpl;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.service.CryptoLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;


public class Vendor extends VendrWrapper implements AddressPerson {
	
	private static final long serialVersionUID = -8375561258486068131L;
	public static final Vendor DEFAULT_PERSON = new Vendor( new VendrImpl() );
	public static final String TAXID = "TAXID";
	
	private Crypto _crypto = null;
	private String _taxId = StringPool.BLANK;
	private Primary caregiver = null;
	Boolean validUspsAddress = null;
	Boolean changed = false;
	
	public Vendor(Vendr vendr) {
		super(vendr);
	}

	public Vendor( Vendr vendr, Persn caregiver ) {
		super(vendr);
		this.caregiver = new Primary (caregiver);
		super.setPersnId( caregiver.getPersnId() );
	}

	private Crypto loadCrypto() {
		try {
			if ( getVendrId() > 0 ){
				if ( _crypto == null ){
					_crypto = CryptoLocalServiceUtil.getCrypto( getVendrId(), TAXID );
				}
				if ( _crypto == null ){
					_crypto = new CryptoImpl();
					_crypto.setType( TAXID );
					_crypto.setOwnerId( getVendrId() );
				} else {
					_taxId = _crypto.getValue();
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return _crypto;
	}
	
	public void setTaxId ( String metadata ){
		if ( Person.SSN_FORMAT.equals(metadata) ){
			metadata = StringPool.BLANK;
		}
		if ( loadCrypto() != null ){
//			encrypt:
//			c.setValue( com.liferay.portal.kernel.util.Base64.fromURLSafe( metadata ) );
			if ( !metadata.equals( _crypto.getValue() ) ){
				changed = true;
				_crypto.setValue(metadata);
			}
		}
		_taxId = metadata;
	}
	
	public String getTaxId(){
		if ( loadCrypto() != null ){
//			decript:
//			return com.liferay.portal.kernel.util.Base64.toURLSafe( c.getValue() );
			return _crypto.getValue();
		}
		if ( Toolbox.isEmpty(_taxId) && caregiver != null ){
			setTaxId( caregiver.getSsn() );
		}
		return _taxId;
	}
	
	public java.lang.String getICN() {
		
		if ( Toolbox.isEmpty( super.getICN() ) && caregiver != null ){
			super.setICN( caregiver.getICN() );
		}
		return super.getICN();
        
	}
	
    public void setLastName( String string ) {
    	if ( !string.equals( super.getLastName() ) ){
    		changed = true;
			super.setLastName( string );
		}
    }
    
    public void setFirstName( String string ) {
    	if ( !string.equals( super.getFirstName() ) ){
			changed = true;
			super.setFirstName( string );
		}
    }
    
    public void setAddress( String string ) {
    	if ( !string.equals( super.getAddress() ) ){
			changed = true;
			super.setAddress( string );
		}
    }
    
    public void setCity( String string ) {
    	if ( !string.equals( super.getCity() ) ){
			changed = true;
			super.setCity( string );
		}
    }
    
    public void setState( String string ) {
    	if ( !string.equals( super.getState() ) ){
			changed = true;
			super.setState( string );
		}
    }
    
    public void setCountry( String string ) {
    	if ( !string.equals( super.getCountry() ) ){
			changed = true;
			super.setCountry( string );
		}
    }
    
    public void setZip( String string ) {
    	if ( !string.equals( super.getZip() ) ){
			changed = true;
			super.setZip( string );
		}
    }
	
//	public void setPaymentMethod( String string ) {
//		if ( !string.equals( super.getPaymentMethod() ) ){
//			changed = true;
//			super.setPaymentMethod( string );
//		}
//	}
	
//	public void setDirectDepositInfo( String string ) {
//		if ( !string.equals( super.getDirectDepositInfo() ) ){
//			changed = true;
//			super.setDirectDepositInfo( string );
//		}
//	}
	
	public void setICN( String string ) {
		if ( !string.equals( super.getICN() ) ){
			changed = true;
			super.setICN( string );
		}
	}
	
    public java.lang.String getLastName() {
    	if ( Toolbox.isEmpty( super.getLastName() ) && caregiver != null ){
			setLastName( caregiver.getLastName() );
		}
        return super.getLastName();
    }
    
    public java.lang.String getFirstName() {
    	if ( Toolbox.isEmpty( super.getFirstName() ) && caregiver != null ){
			setFirstName( caregiver.getFirstName() );
		}
        return super.getFirstName();
    }
    
    public java.lang.String getAddress() {
    	if ( Toolbox.isEmpty( super.getAddress() ) && caregiver != null ){
			setAddress( caregiver.getAddress() );
		}
        return super.getAddress();
    }
    
    public java.lang.String getCity() {
    	if ( Toolbox.isEmpty( super.getCity() ) && caregiver != null ){
			setCity( caregiver.getCity() );
		}
        return super.getCity();
    }
    
    public java.lang.String getState() {
    	if ( Toolbox.isEmpty( super.getState() ) && caregiver != null ){
			setState( caregiver.getState() );
		}
        return super.getState();
    }
    
    public java.lang.String getCountry() {
    	if ( Toolbox.isEmpty( super.getCountry() ) && caregiver != null ){
			setCountry( caregiver.getCountry() );
		}
        return super.getCountry();
    }
    
    public java.lang.String getZip() {
    	if ( Toolbox.isEmpty( super.getZip() ) && caregiver != null ){
			setZip( caregiver.getZip() );
		}
        return super.getZip();
    }
	
	
	public boolean isValidUspsAddress(){
		if ( validUspsAddress == null ){
			if ( !Toolbox.isEmpty(getAddress()) && !Toolbox.isEmpty(getCity()) && !Toolbox.isEmpty(getState()) && !Toolbox.isEmpty(getZip()) && !"0".equals(getZip() )  ){
				_log.info("making USPS call with " + getAddress() + " " +  getCity() + " " +  getState() + " " + getZip() );
				validUspsAddress = CaretUtil.isValidateUspsAddress( getAddress(), getCity(), getState(), getZip() );
			}
		}
		if ( validUspsAddress == null ){
			validUspsAddress = false;
		}
		return validUspsAddress;
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		modelAttributes.put( TAXID, loadCrypto() != null? _crypto.getValue() : _taxId );
		return modelAttributes;
	}
	
	public void setModelAttributes( Map<String, Object> map ) {
		if ( map.containsKey( TAXID ) ){
			setTaxId( Toolbox.formatSsn( map.get(TAXID).toString() ) );
		}
		super.setModelAttributes(map);
	}
	
	public void persist () throws SystemException{
		super.persist();
		if ( loadCrypto() != null ){
			_crypto.setValue( _taxId );
			if ( ! Toolbox.isEmpty( _crypto.getValue() ) ){
				CryptoLocalServiceUtil.updateCrypto(_crypto);
			}
		}
		if ( Toolbox.isEmpty( _crypto.getValue() ) ){
			throw new com.liferay.portal.kernel.exception.SystemException("TAX ID cannot be empty");
		}
		if ( Toolbox.isEmpty( getFirstName() ) ){
			throw new com.liferay.portal.kernel.exception.SystemException("First name cannot be empty");
		}
		if ( Toolbox.isEmpty( getLastName() ) ){
			throw new com.liferay.portal.kernel.exception.SystemException("Last name cannot be empty");
		}
	}

	public WorkType getWorkType() {
//		if ( Toolbox.isEmpty( getDirectDepositInfo() ) || Toolbox.isEmpty( getPaymentMethod() ) ){
//			if ( getVendrId() == 0 ){
//				return WorkType.VENDOR_CREATE_HOLD;
//			}
//			return WorkType.VENDOR_UPDATE_HOLD;
//		}
		if ( getVendrId() == 0 ){
			return WorkType.VENDOR_CREATE;
		}
		if ( changed ){
			return WorkType.VENDOR_UPDATE;
		}
		return null;
	}

	private static Log _log = LogFactoryUtil.getLog( Vendor.class );
}
