package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Persn;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;

public class Primary extends Person {

	private static final long serialVersionUID = 1L;


	public static final String PRIMARY_VIEW = "/jsp/online/primary.jsp";
	public final static String MEDI_ENROLLED_ATTRIBUTE = "mediEnrolled";
	final static String ENROLLED_IN_MEDICARE = "enrolled-in-medicare";
	private boolean enrolledInMe = false;
	private BgAsn enrollmentInMe = null;
	
	final static String OTHER_HEALTH_INSURANCE = "other-health-Insurance";
	public final static String OTHER_INSURANCE_ATTRIBUTE = "otherHealthInsuranceYesNo";
	private boolean enrolledInOt = false;
	private BgAsn enrollmentInOt = null;
	
	public Primary(Persn person) {
		super(person);
		loadMediEnrollment();
		loadOthEnrollment();
	}
	
	public Role getRole(){
		return Person.Role.PRIMARY;
	}
	
	private BgAsn loadMediEnrollment() {
		try {
			if ( getPersnId() > 0 ){
				if ( enrollmentInMe == null ){
					List<BoxGp> enrollmentList = CaretUtil.loadBoxGroup(Person.class.getName(), ENROLLED_IN_MEDICARE);
					for ( BoxGp boxGp: enrollmentList ){
						if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
							enrollmentInMe = BoxGpLocalServiceUtil.getBoxGroupAssociation( getPersnId(), boxGp.getBoxGpId() );
							if ( enrollmentInMe == null ){
								enrollmentInMe = new BgAsnImpl();
								enrollmentInMe.setBoxGpId( boxGp.getBoxGpId() );
								enrollmentInMe.setOwnerId( getPersnId() );
							}
						}
					}
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return enrollmentInMe;
	}
	
	private BgAsn loadOthEnrollment() {
		try {
			if ( getPersnId() > 0 ){
				if ( enrollmentInOt == null ){
					List<BoxGp> enrollmentList = CaretUtil.loadBoxGroup(Person.class.getName(), OTHER_HEALTH_INSURANCE);
					for ( BoxGp boxGp: enrollmentList ){
						if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
							enrollmentInOt = BoxGpLocalServiceUtil.getBoxGroupAssociation( getPersnId(), boxGp.getBoxGpId() );
							if ( enrollmentInOt == null ){
								enrollmentInOt = new BgAsnImpl();
								enrollmentInOt.setBoxGpId( boxGp.getBoxGpId() );
								enrollmentInOt.setOwnerId( getPersnId() );
							}
						}
					}
				}
//				if ( enrollmentInOt != null ){
//					enrolledInOt = enrollmentInOt.getSelected();
//				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return enrollmentInOt;
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  

		modelAttributes.put( OTHER_INSURANCE_ATTRIBUTE, loadOthEnrollment() != null? enrollmentInOt.getSelected() : enrolledInOt );
		modelAttributes.put( MEDI_ENROLLED_ATTRIBUTE, loadMediEnrollment() != null? enrollmentInMe.getSelected() : enrolledInMe );
		
		return modelAttributes;
	}

	public void setModelAttributes( Map<String, Object> modelAttributes ) {
		super.setModelAttributes(modelAttributes);
		Object medicareEnrolled = modelAttributes.get( MEDI_ENROLLED_ATTRIBUTE );
		if ( medicareEnrolled != null && medicareEnrolled instanceof Boolean ){
			setMediEnrolled( (Boolean) medicareEnrolled );
		} else {
			_log.warn("Could not set VA Medi Enrollment");
		} 
		
//		Object tierAppealed = modelAttributes.get( TIER_APPEAL_ATTRIBUTE );
//		if ( tierAppealed != null && tierAppealed instanceof Boolean ){
//			setTierAppealed( (Boolean) medicareEnrolled );
//		} else {
//			_log.warn("Could not set Tier Appealment");
//		}
		
		Object otherHealthInsurance = modelAttributes.get( OTHER_INSURANCE_ATTRIBUTE );
		if ( otherHealthInsurance != null && otherHealthInsurance instanceof Boolean ){
			setOtherInsChecked( (Boolean) otherHealthInsurance );
		} else {
			_log.warn("Could not set Other Health Insurance");
		}
	}
	
	public void persist () throws SystemException{
		super.persist();
		if ( loadMediEnrollment() != null ){
			enrollmentInMe.setSelected(enrolledInMe);
			BgAsnLocalServiceUtil.updateBgAsn(enrollmentInMe);
		}
		if ( loadOthEnrollment() != null ){
			enrollmentInOt.setSelected(enrolledInOt);
			BgAsnLocalServiceUtil.updateBgAsn(enrollmentInOt);
		}

	}

	public void setOtherInsChecked (boolean enrolled) {
		if ( loadOthEnrollment() != null ){
			enrollmentInOt.setSelected(enrolled);
		}
		enrolledInOt = enrolled;
	}
	
	public boolean isOtherInsChecked (){
		return getOtherInsChecked();
	}
	public boolean getOtherInsChecked (){
		if ( loadOthEnrollment() != null ){
			return enrollmentInOt.isSelected();
		}
		return enrolledInOt;
	}
	
	public void setMediEnrolled(boolean enrolled) {
		if ( loadMediEnrollment() != null ){
			enrollmentInMe.setSelected(enrolled);
		}
		enrolledInMe = enrolled;
	}
	
	public boolean isMediEnrolled(){
		return getMediEnrolled();
	}
	public boolean getMediEnrolled(){
		if ( loadMediEnrollment() != null ){
			return enrollmentInMe.isSelected();
		}
		return enrolledInMe;
	}

	
	public List<String> getTierList( String[] tiers, String selected){
		return getTierList(tiers, selected, true);
	}
	public List<String> getTierList( String[] tiers, String selected, boolean includeAppeals ){
		List<String> list = new ArrayList<String>();
		for ( String tier : tiers){
			if ( tier.equals(selected) ){
				list.add(tier);
				continue;
			}
			list.add(tier);
			if ( includeAppeals ){
				list.add("appeal-"+ selected + "-to-" +tier);
			}
		}
		Collections.sort(list);
		return list;
	}
	
	public String getRelationship(){ return super.getRelationship(); }
	public boolean isFamily(){ return super.isFamily();}
	public boolean isNotFamily(){ return super.isNotFamily(); }
	
	public String getOnlineView(){ return PRIMARY_VIEW; }
}
