package gov.va.caret.model.support;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.CallWrapper;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class CallSupport extends CallWrapper {

	String personName = null;
	String personLastName = null;
	String caregiverName = null;
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	private Boolean docLoaded = null;
//	private WorkType workType = null;
	private boolean isCallReferral = false;
	CalEt callEvent = null;
	private Map<String,Note> notes = new HashMap<String,Note>();
	
	private static final long serialVersionUID = 1L;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public CallSupport(gov.va.caret.model.Call Call) {
		super(Call);
		if ( !"Referral".equals(getCallType() ) ){
			isCallReferral = getWorkPrimaryKey() > 0;
		}
	}

	public String getPersonName() {
		if ( personName == null ){
			this.personName = getFullName( getVeteranPersnId() );
		}
		return personName;
	}
	
	public String getVeteranLastName() {
		if ( personLastName == null ){
			this.personLastName = getLastName( getVeteranPersnId() );
		}
		return personLastName;
	}

	public String getCaregiverName() {
		if ( caregiverName == null ){
			this.caregiverName = getFullName( getCallerPersnId() );
		}
		return caregiverName;
	}
	
	public List<Docum> getDocuments(){
		try{
			if ( isDocLoaded() ){
				return DocumLocalServiceUtil.getByPrimaryKey( getCallId() );
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public WorkType getWorkType(){
		if ( "Referral".equals(getCallType() ) ){
			return WorkType.REFERRAL;
		} else {
			return WorkType.CALL_REFERRAL;
		}
	}
	
	public String getCreateEntry(){
		if ( isCallReferral ){
			return CaretStrPool.CREATE_CALLS;
		} else {
			return CaretStrPool.CREATE_REFERRAL;
		}
	}
	
	public boolean isDocLoaded(){
		if ( docLoaded == null ){
			try {
				docLoaded = DocumLocalServiceUtil.getByPrimaryKeyCount( getCallId() ) > 0;
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return docLoaded;
	}
	
	public boolean isTransferable(){
		switch (getWorkType()){
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public boolean isAssignable(){
		switch (getWorkType()){
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public String getDueDateStr ( ){
		String dueDate = StringPool.BLANK;
		if ( getWorkPrimaryKey() > 0 ){
			try {
				Date due = WorImLocalServiceUtil.getWorIm(getWorkPrimaryKey()).getDueDate();
				return Toolbox.formatDateCprs(due);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return dueDate;
	}
	
	public String getCreateDateStr ( ){
		if ( getCreationDate() != null ){
			return Toolbox.formatDateCprs( getCreationDate() );
		}
		return StringPool.BLANK;
	}
	
	public String getModificationDateStr ( ){
		if ( getModificationDate() != null ){
			return Toolbox.formatDateCprs( getModificationDate() );
		}
//		if ( getCreationDate() != null ){
//			return Toolbox.formatDateCprs( getCreationDate() );
//		}
		return StringPool.BLANK;
	}
	
	public String getLastName ( long persnId ){
		if ( persnId > 0 ){
			try {
				return PersnLocalServiceUtil.getPersn( persnId ).getLastName();
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return StringPool.BLANK;
	}
	
	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			try {
				Persn persn = PersnLocalServiceUtil.getPersn( persnId );
				return CaretStrPool.UNKNOWN_IDENTITY.equals( persn.getStatus() ) ? "Unknown" : persn.getLastName() + StringPool.COMMA_AND_SPACE + persn.getFirstName();
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			return CaretUtil.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getVeteranPersnId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Person ID cannot be 0");
		}
		super.persist();
		saveCustomAttributes();
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( CallSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getCallId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp getCustomAttribute ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( CallSupport.class.getName(), String.valueOf( getCallId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	
	private void saveCustomAttributes() {
		if ( !customAttributes.isEmpty() ){
			for ( BgLae value : customAttributes.values() ){
				try {
					CaretLocalServiceUtil.save(value);
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note.getNoteId() == 0 ) try {
				note.setChainId( getCallId() );
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), 75)) );
		}
		return modelAttributes;
	}

	private BgLae getLeaAttr ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute, applicationId );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getCallId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}

	public void setNote ( String attribute, String comment, long userId, Date createDate, long groupId ){
		 notes.put( attribute, CaretUtil.createNote( createDate, getCallId(), groupId, userId, comment ) );
	}

	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	
}
