package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.WorSe;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing WorSe in entity cache.
 *
 * @author caret
 * @see WorSe
 * @generated
 */
public class WorSeCacheModel implements CacheModel<WorSe>, Externalizable {
    public long worSeId;
    public long worImId;
    public String step;
    public long userId;
    public long creationDate;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{worSeId=");
        sb.append(worSeId);
        sb.append(", worImId=");
        sb.append(worImId);
        sb.append(", step=");
        sb.append(step);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public WorSe toEntityModel() {
        WorSeImpl worSeImpl = new WorSeImpl();

        worSeImpl.setWorSeId(worSeId);
        worSeImpl.setWorImId(worImId);

        if (step == null) {
            worSeImpl.setStep(StringPool.BLANK);
        } else {
            worSeImpl.setStep(step);
        }

        worSeImpl.setUserId(userId);

        if (creationDate == Long.MIN_VALUE) {
            worSeImpl.setCreationDate(null);
        } else {
            worSeImpl.setCreationDate(new Date(creationDate));
        }

        worSeImpl.resetOriginalValues();

        return worSeImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        worSeId = objectInput.readLong();
        worImId = objectInput.readLong();
        step = objectInput.readUTF();
        userId = objectInput.readLong();
        creationDate = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(worSeId);
        objectOutput.writeLong(worImId);

        if (step == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(step);
        }

        objectOutput.writeLong(userId);
        objectOutput.writeLong(creationDate);
    }
}
