package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.WorIm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing WorIm in entity cache.
 *
 * @author caret
 * @see WorIm
 * @generated
 */
public class WorImCacheModel implements CacheModel<WorIm>, Externalizable {
    public long worImId;
    public String type;
    public long classId;
    public long classPk;
    public String status;
    public long creationDate;
    public long dueDate;
    public long completionDate;
    public long completionBy;
    public long groupId;
    public long userId;
    public long caregiverId;
    public long persnId;
    public long queId;
    public long vcgId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(31);

        sb.append("{worImId=");
        sb.append(worImId);
        sb.append(", type=");
        sb.append(type);
        sb.append(", classId=");
        sb.append(classId);
        sb.append(", classPk=");
        sb.append(classPk);
        sb.append(", status=");
        sb.append(status);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", dueDate=");
        sb.append(dueDate);
        sb.append(", completionDate=");
        sb.append(completionDate);
        sb.append(", completionBy=");
        sb.append(completionBy);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", caregiverId=");
        sb.append(caregiverId);
        sb.append(", persnId=");
        sb.append(persnId);
        sb.append(", queId=");
        sb.append(queId);
        sb.append(", vcgId=");
        sb.append(vcgId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public WorIm toEntityModel() {
        WorImImpl worImImpl = new WorImImpl();

        worImImpl.setWorImId(worImId);

        if (type == null) {
            worImImpl.setType(StringPool.BLANK);
        } else {
            worImImpl.setType(type);
        }

        worImImpl.setClassId(classId);
        worImImpl.setClassPk(classPk);

        if (status == null) {
            worImImpl.setStatus(StringPool.BLANK);
        } else {
            worImImpl.setStatus(status);
        }

        if (creationDate == Long.MIN_VALUE) {
            worImImpl.setCreationDate(null);
        } else {
            worImImpl.setCreationDate(new Date(creationDate));
        }

        if (dueDate == Long.MIN_VALUE) {
            worImImpl.setDueDate(null);
        } else {
            worImImpl.setDueDate(new Date(dueDate));
        }

        if (completionDate == Long.MIN_VALUE) {
            worImImpl.setCompletionDate(null);
        } else {
            worImImpl.setCompletionDate(new Date(completionDate));
        }

        worImImpl.setCompletionBy(completionBy);
        worImImpl.setGroupId(groupId);
        worImImpl.setUserId(userId);
        worImImpl.setCaregiverId(caregiverId);
        worImImpl.setPersnId(persnId);
        worImImpl.setQueId(queId);
        worImImpl.setVcgId(vcgId);

        worImImpl.resetOriginalValues();

        return worImImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        worImId = objectInput.readLong();
        type = objectInput.readUTF();
        classId = objectInput.readLong();
        classPk = objectInput.readLong();
        status = objectInput.readUTF();
        creationDate = objectInput.readLong();
        dueDate = objectInput.readLong();
        completionDate = objectInput.readLong();
        completionBy = objectInput.readLong();
        groupId = objectInput.readLong();
        userId = objectInput.readLong();
        caregiverId = objectInput.readLong();
        persnId = objectInput.readLong();
        queId = objectInput.readLong();
        vcgId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(worImId);

        if (type == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(type);
        }

        objectOutput.writeLong(classId);
        objectOutput.writeLong(classPk);

        if (status == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(status);
        }

        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(dueDate);
        objectOutput.writeLong(completionDate);
        objectOutput.writeLong(completionBy);
        objectOutput.writeLong(groupId);
        objectOutput.writeLong(userId);
        objectOutput.writeLong(caregiverId);
        objectOutput.writeLong(persnId);
        objectOutput.writeLong(queId);
        objectOutput.writeLong(vcgId);
    }
}
