package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.StiPt;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing StiPt in entity cache.
 *
 * @author caret
 * @see StiPt
 * @generated
 */
public class StiPtCacheModel implements CacheModel<StiPt>, Externalizable {
    public long stiPtId;
    public long stiRdId;
    public long vendrId;
    public String tier;
    public String tierHours;
    public String blsRateHourly;
    public String dailyRate;
    public String monthlyPayment;
    public String stipendStatus;
    public long stipendApprovedDate;
    public long stipendStartDate;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(25);

        sb.append("{stiPtId=");
        sb.append(stiPtId);
        sb.append(", stiRdId=");
        sb.append(stiRdId);
        sb.append(", vendrId=");
        sb.append(vendrId);
        sb.append(", tier=");
        sb.append(tier);
        sb.append(", tierHours=");
        sb.append(tierHours);
        sb.append(", blsRateHourly=");
        sb.append(blsRateHourly);
        sb.append(", dailyRate=");
        sb.append(dailyRate);
        sb.append(", monthlyPayment=");
        sb.append(monthlyPayment);
        sb.append(", stipendStatus=");
        sb.append(stipendStatus);
        sb.append(", stipendApprovedDate=");
        sb.append(stipendApprovedDate);
        sb.append(", stipendStartDate=");
        sb.append(stipendStartDate);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public StiPt toEntityModel() {
        StiPtImpl stiPtImpl = new StiPtImpl();

        stiPtImpl.setStiPtId(stiPtId);
        stiPtImpl.setStiRdId(stiRdId);
        stiPtImpl.setVendrId(vendrId);

        if (tier == null) {
            stiPtImpl.setTier(StringPool.BLANK);
        } else {
            stiPtImpl.setTier(tier);
        }

        if (tierHours == null) {
            stiPtImpl.setTierHours(StringPool.BLANK);
        } else {
            stiPtImpl.setTierHours(tierHours);
        }

        if (blsRateHourly == null) {
            stiPtImpl.setBlsRateHourly(StringPool.BLANK);
        } else {
            stiPtImpl.setBlsRateHourly(blsRateHourly);
        }

        if (dailyRate == null) {
            stiPtImpl.setDailyRate(StringPool.BLANK);
        } else {
            stiPtImpl.setDailyRate(dailyRate);
        }

        if (monthlyPayment == null) {
            stiPtImpl.setMonthlyPayment(StringPool.BLANK);
        } else {
            stiPtImpl.setMonthlyPayment(monthlyPayment);
        }

        if (stipendStatus == null) {
            stiPtImpl.setStipendStatus(StringPool.BLANK);
        } else {
            stiPtImpl.setStipendStatus(stipendStatus);
        }

        if (stipendApprovedDate == Long.MIN_VALUE) {
            stiPtImpl.setStipendApprovedDate(null);
        } else {
            stiPtImpl.setStipendApprovedDate(new Date(stipendApprovedDate));
        }

        if (stipendStartDate == Long.MIN_VALUE) {
            stiPtImpl.setStipendStartDate(null);
        } else {
            stiPtImpl.setStipendStartDate(new Date(stipendStartDate));
        }

        stiPtImpl.setGroupId(groupId);

        stiPtImpl.resetOriginalValues();

        return stiPtImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        stiPtId = objectInput.readLong();
        stiRdId = objectInput.readLong();
        vendrId = objectInput.readLong();
        tier = objectInput.readUTF();
        tierHours = objectInput.readUTF();
        blsRateHourly = objectInput.readUTF();
        dailyRate = objectInput.readUTF();
        monthlyPayment = objectInput.readUTF();
        stipendStatus = objectInput.readUTF();
        stipendApprovedDate = objectInput.readLong();
        stipendStartDate = objectInput.readLong();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(stiPtId);
        objectOutput.writeLong(stiRdId);
        objectOutput.writeLong(vendrId);

        if (tier == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(tier);
        }

        if (tierHours == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(tierHours);
        }

        if (blsRateHourly == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(blsRateHourly);
        }

        if (dailyRate == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(dailyRate);
        }

        if (monthlyPayment == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(monthlyPayment);
        }

        if (stipendStatus == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(stipendStatus);
        }

        objectOutput.writeLong(stipendApprovedDate);
        objectOutput.writeLong(stipendStartDate);
        objectOutput.writeLong(groupId);
    }
}
