package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Persn;
import gov.va.caret.model.PersnModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Persn service. Represents a row in the &quot;CARET_PERSON&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.PersnModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PersnImpl}.
 * </p>
 *
 * @author caret
 * @see PersnImpl
 * @see gov.va.caret.model.Persn
 * @see gov.va.caret.model.PersnModel
 * @generated
 */
public class PersnModelImpl extends BaseModelImpl<Persn> implements PersnModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a persn model instance should use the {@link gov.va.caret.model.Persn} interface instead.
     */
    public static final String TABLE_NAME = "CARET_PERSON";
    public static final Object[][] TABLE_COLUMNS = {
            { "persnId", Types.BIGINT },
            { "persnUserId", Types.BIGINT },
            { "lastName", Types.VARCHAR },
            { "firstName", Types.VARCHAR },
            { "middleName", Types.VARCHAR },
            { "prefix", Types.VARCHAR },
            { "suffix", Types.VARCHAR },
            { "birthDate", Types.TIMESTAMP },
            { "deceasedDate", Types.TIMESTAMP },
            { "gender", Types.VARCHAR },
            { "address", Types.VARCHAR },
            { "address2", Types.VARCHAR },
            { "city", Types.VARCHAR },
            { "state_", Types.VARCHAR },
            { "country", Types.VARCHAR },
            { "zip", Types.VARCHAR },
            { "phone", Types.VARCHAR },
            { "phone2", Types.VARCHAR },
            { "email", Types.VARCHAR },
            { "email2", Types.VARCHAR },
            { "status", Types.VARCHAR },
            { "source", Types.VARCHAR },
            { "MVI200MID", Types.VARCHAR },
            { "otherHealthInsurance", Types.VARCHAR },
            { "userId", Types.BIGINT },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_PERSON (persnId LONG not null primary key,persnUserId LONG,lastName VARCHAR(75) null,firstName VARCHAR(75) null,middleName VARCHAR(75) null,prefix VARCHAR(75) null,suffix VARCHAR(75) null,birthDate DATE null,deceasedDate DATE null,gender VARCHAR(75) null,address VARCHAR(75) null,address2 VARCHAR(75) null,city VARCHAR(75) null,state_ VARCHAR(75) null,country VARCHAR(75) null,zip VARCHAR(75) null,phone VARCHAR(75) null,phone2 VARCHAR(75) null,email VARCHAR(75) null,email2 VARCHAR(75) null,status VARCHAR(75) null,source VARCHAR(75) null,MVI200MID VARCHAR(75) null,otherHealthInsurance VARCHAR(75) null,userId LONG,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_PERSON";
    public static final String ORDER_BY_JPQL = " ORDER BY persn.persnId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_PERSON.persnId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Persn"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Persn"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Persn"),
            true);
    public static long BIRTHDATE_COLUMN_BITMASK = 1L;
    public static long EXTERNALID_COLUMN_BITMASK = 2L;
    public static long FIRSTNAME_COLUMN_BITMASK = 4L;
    public static long GENDER_COLUMN_BITMASK = 8L;
    public static long LASTNAME_COLUMN_BITMASK = 16L;
    public static long PERSNUSERID_COLUMN_BITMASK = 32L;
    public static long PERSNID_COLUMN_BITMASK = 64L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Persn"));
    private static ClassLoader _classLoader = Persn.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Persn.class };
    private long _persnId;
    private long _persnUserId;
    private String _persnUserUuid;
    private long _originalPersnUserId;
    private boolean _setOriginalPersnUserId;
    private String _lastName;
    private String _originalLastName;
    private String _firstName;
    private String _originalFirstName;
    private String _middleName;
    private String _prefix;
    private String _suffix;
    private Date _birthDate;
    private Date _originalBirthDate;
    private Date _deceasedDate;
    private String _gender;
    private String _originalGender;
    private String _address;
    private String _address2;
    private String _city;
    private String _state;
    private String _country;
    private String _zip;
    private String _phone;
    private String _phone2;
    private String _email;
    private String _email2;
    private String _status;
    private String _source;
    private String _externalId;
    private String _originalExternalId;
    private String _otherHealthInsurance;
    private long _userId;
    private String _userUuid;
    private long _groupId;
    private long _columnBitmask;
    private Persn _escapedModel;

    public PersnModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _persnId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setPersnId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _persnId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Persn.class;
    }

    @Override
    public String getModelClassName() {
        return Persn.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("persnId", getPersnId());
        attributes.put("persnUserId", getPersnUserId());
        attributes.put("lastName", getLastName());
        attributes.put("firstName", getFirstName());
        attributes.put("middleName", getMiddleName());
        attributes.put("prefix", getPrefix());
        attributes.put("suffix", getSuffix());
        attributes.put("birthDate", getBirthDate());
        attributes.put("deceasedDate", getDeceasedDate());
        attributes.put("gender", getGender());
        attributes.put("address", getAddress());
        attributes.put("address2", getAddress2());
        attributes.put("city", getCity());
        attributes.put("state", getState());
        attributes.put("country", getCountry());
        attributes.put("zip", getZip());
        attributes.put("phone", getPhone());
        attributes.put("phone2", getPhone2());
        attributes.put("email", getEmail());
        attributes.put("email2", getEmail2());
        attributes.put("status", getStatus());
        attributes.put("source", getSource());
        attributes.put("externalId", getExternalId());
        attributes.put("otherHealthInsurance", getOtherHealthInsurance());
        attributes.put("userId", getUserId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        Long persnUserId = (Long) attributes.get("persnUserId");

        if (persnUserId != null) {
            setPersnUserId(persnUserId);
        }

        String lastName = (String) attributes.get("lastName");

        if (lastName != null) {
            setLastName(lastName);
        }

        String firstName = (String) attributes.get("firstName");

        if (firstName != null) {
            setFirstName(firstName);
        }

        String middleName = (String) attributes.get("middleName");

        if (middleName != null) {
            setMiddleName(middleName);
        }

        String prefix = (String) attributes.get("prefix");

        if (prefix != null) {
            setPrefix(prefix);
        }

        String suffix = (String) attributes.get("suffix");

        if (suffix != null) {
            setSuffix(suffix);
        }

        Date birthDate = (Date) attributes.get("birthDate");

        if (birthDate != null) {
            setBirthDate(birthDate);
        }

        Date deceasedDate = (Date) attributes.get("deceasedDate");

        if (deceasedDate != null) {
            setDeceasedDate(deceasedDate);
        }

        String gender = (String) attributes.get("gender");

        if (gender != null) {
            setGender(gender);
        }

        String address = (String) attributes.get("address");

        if (address != null) {
            setAddress(address);
        }

        String address2 = (String) attributes.get("address2");

        if (address2 != null) {
            setAddress2(address2);
        }

        String city = (String) attributes.get("city");

        if (city != null) {
            setCity(city);
        }

        String state = (String) attributes.get("state");

        if (state != null) {
            setState(state);
        }

        String country = (String) attributes.get("country");

        if (country != null) {
            setCountry(country);
        }

        String zip = (String) attributes.get("zip");

        if (zip != null) {
            setZip(zip);
        }

        String phone = (String) attributes.get("phone");

        if (phone != null) {
            setPhone(phone);
        }

        String phone2 = (String) attributes.get("phone2");

        if (phone2 != null) {
            setPhone2(phone2);
        }

        String email = (String) attributes.get("email");

        if (email != null) {
            setEmail(email);
        }

        String email2 = (String) attributes.get("email2");

        if (email2 != null) {
            setEmail2(email2);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String source = (String) attributes.get("source");

        if (source != null) {
            setSource(source);
        }

        String externalId = (String) attributes.get("externalId");

        if (externalId != null) {
            setExternalId(externalId);
        }

        String otherHealthInsurance = (String) attributes.get(
                "otherHealthInsurance");

        if (otherHealthInsurance != null) {
            setOtherHealthInsurance(otherHealthInsurance);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getPersnId() {
        return _persnId;
    }

    @Override
    public void setPersnId(long persnId) {
        _persnId = persnId;
    }

    @Override
    public long getPersnUserId() {
        return _persnUserId;
    }

    @Override
    public void setPersnUserId(long persnUserId) {
        _columnBitmask |= PERSNUSERID_COLUMN_BITMASK;

        if (!_setOriginalPersnUserId) {
            _setOriginalPersnUserId = true;

            _originalPersnUserId = _persnUserId;
        }

        _persnUserId = persnUserId;
    }

    @Override
    public String getPersnUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getPersnUserId(), "uuid", _persnUserUuid);
    }

    @Override
    public void setPersnUserUuid(String persnUserUuid) {
        _persnUserUuid = persnUserUuid;
    }

    public long getOriginalPersnUserId() {
        return _originalPersnUserId;
    }

    @Override
    public String getLastName() {
        if (_lastName == null) {
            return StringPool.BLANK;
        } else {
            return _lastName;
        }
    }

    @Override
    public void setLastName(String lastName) {
        _columnBitmask |= LASTNAME_COLUMN_BITMASK;

        if (_originalLastName == null) {
            _originalLastName = _lastName;
        }

        _lastName = lastName;
    }

    public String getOriginalLastName() {
        return GetterUtil.getString(_originalLastName);
    }

    @Override
    public String getFirstName() {
        if (_firstName == null) {
            return StringPool.BLANK;
        } else {
            return _firstName;
        }
    }

    @Override
    public void setFirstName(String firstName) {
        _columnBitmask |= FIRSTNAME_COLUMN_BITMASK;

        if (_originalFirstName == null) {
            _originalFirstName = _firstName;
        }

        _firstName = firstName;
    }

    public String getOriginalFirstName() {
        return GetterUtil.getString(_originalFirstName);
    }

    @Override
    public String getMiddleName() {
        if (_middleName == null) {
            return StringPool.BLANK;
        } else {
            return _middleName;
        }
    }

    @Override
    public void setMiddleName(String middleName) {
        _middleName = middleName;
    }

    @Override
    public String getPrefix() {
        if (_prefix == null) {
            return StringPool.BLANK;
        } else {
            return _prefix;
        }
    }

    @Override
    public void setPrefix(String prefix) {
        _prefix = prefix;
    }

    @Override
    public String getSuffix() {
        if (_suffix == null) {
            return StringPool.BLANK;
        } else {
            return _suffix;
        }
    }

    @Override
    public void setSuffix(String suffix) {
        _suffix = suffix;
    }

    @Override
    public Date getBirthDate() {
        return _birthDate;
    }

    @Override
    public void setBirthDate(Date birthDate) {
        _columnBitmask |= BIRTHDATE_COLUMN_BITMASK;

        if (_originalBirthDate == null) {
            _originalBirthDate = _birthDate;
        }

        _birthDate = birthDate;
    }

    public Date getOriginalBirthDate() {
        return _originalBirthDate;
    }

    @Override
    public Date getDeceasedDate() {
        return _deceasedDate;
    }

    @Override
    public void setDeceasedDate(Date deceasedDate) {
        _deceasedDate = deceasedDate;
    }

    @Override
    public String getGender() {
        if (_gender == null) {
            return StringPool.BLANK;
        } else {
            return _gender;
        }
    }

    @Override
    public void setGender(String gender) {
        _columnBitmask |= GENDER_COLUMN_BITMASK;

        if (_originalGender == null) {
            _originalGender = _gender;
        }

        _gender = gender;
    }

    public String getOriginalGender() {
        return GetterUtil.getString(_originalGender);
    }

    @Override
    public String getAddress() {
        if (_address == null) {
            return StringPool.BLANK;
        } else {
            return _address;
        }
    }

    @Override
    public void setAddress(String address) {
        _address = address;
    }

    @Override
    public String getAddress2() {
        if (_address2 == null) {
            return StringPool.BLANK;
        } else {
            return _address2;
        }
    }

    @Override
    public void setAddress2(String address2) {
        _address2 = address2;
    }

    @Override
    public String getCity() {
        if (_city == null) {
            return StringPool.BLANK;
        } else {
            return _city;
        }
    }

    @Override
    public void setCity(String city) {
        _city = city;
    }

    @Override
    public String getState() {
        if (_state == null) {
            return StringPool.BLANK;
        } else {
            return _state;
        }
    }

    @Override
    public void setState(String state) {
        _state = state;
    }

    @Override
    public String getCountry() {
        if (_country == null) {
            return StringPool.BLANK;
        } else {
            return _country;
        }
    }

    @Override
    public void setCountry(String country) {
        _country = country;
    }

    @Override
    public String getZip() {
        if (_zip == null) {
            return StringPool.BLANK;
        } else {
            return _zip;
        }
    }

    @Override
    public void setZip(String zip) {
        _zip = zip;
    }

    @Override
    public String getPhone() {
        if (_phone == null) {
            return StringPool.BLANK;
        } else {
            return _phone;
        }
    }

    @Override
    public void setPhone(String phone) {
        _phone = phone;
    }

    @Override
    public String getPhone2() {
        if (_phone2 == null) {
            return StringPool.BLANK;
        } else {
            return _phone2;
        }
    }

    @Override
    public void setPhone2(String phone2) {
        _phone2 = phone2;
    }

    @Override
    public String getEmail() {
        if (_email == null) {
            return StringPool.BLANK;
        } else {
            return _email;
        }
    }

    @Override
    public void setEmail(String email) {
        _email = email;
    }

    @Override
    public String getEmail2() {
        if (_email2 == null) {
            return StringPool.BLANK;
        } else {
            return _email2;
        }
    }

    @Override
    public void setEmail2(String email2) {
        _email2 = email2;
    }

    @Override
    public String getStatus() {
        if (_status == null) {
            return StringPool.BLANK;
        } else {
            return _status;
        }
    }

    @Override
    public void setStatus(String status) {
        _status = status;
    }

    @Override
    public String getSource() {
        if (_source == null) {
            return StringPool.BLANK;
        } else {
            return _source;
        }
    }

    @Override
    public void setSource(String source) {
        _source = source;
    }

    @Override
    public String getExternalId() {
        if (_externalId == null) {
            return StringPool.BLANK;
        } else {
            return _externalId;
        }
    }

    @Override
    public void setExternalId(String externalId) {
        _columnBitmask |= EXTERNALID_COLUMN_BITMASK;

        if (_originalExternalId == null) {
            _originalExternalId = _externalId;
        }

        _externalId = externalId;
    }

    public String getOriginalExternalId() {
        return GetterUtil.getString(_originalExternalId);
    }

    @Override
    public String getOtherHealthInsurance() {
        if (_otherHealthInsurance == null) {
            return StringPool.BLANK;
        } else {
            return _otherHealthInsurance;
        }
    }

    @Override
    public void setOtherHealthInsurance(String otherHealthInsurance) {
        _otherHealthInsurance = otherHealthInsurance;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Persn.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Persn toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Persn) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        PersnImpl persnImpl = new PersnImpl();

        persnImpl.setPersnId(getPersnId());
        persnImpl.setPersnUserId(getPersnUserId());
        persnImpl.setLastName(getLastName());
        persnImpl.setFirstName(getFirstName());
        persnImpl.setMiddleName(getMiddleName());
        persnImpl.setPrefix(getPrefix());
        persnImpl.setSuffix(getSuffix());
        persnImpl.setBirthDate(getBirthDate());
        persnImpl.setDeceasedDate(getDeceasedDate());
        persnImpl.setGender(getGender());
        persnImpl.setAddress(getAddress());
        persnImpl.setAddress2(getAddress2());
        persnImpl.setCity(getCity());
        persnImpl.setState(getState());
        persnImpl.setCountry(getCountry());
        persnImpl.setZip(getZip());
        persnImpl.setPhone(getPhone());
        persnImpl.setPhone2(getPhone2());
        persnImpl.setEmail(getEmail());
        persnImpl.setEmail2(getEmail2());
        persnImpl.setStatus(getStatus());
        persnImpl.setSource(getSource());
        persnImpl.setExternalId(getExternalId());
        persnImpl.setOtherHealthInsurance(getOtherHealthInsurance());
        persnImpl.setUserId(getUserId());
        persnImpl.setGroupId(getGroupId());

        persnImpl.resetOriginalValues();

        return persnImpl;
    }

    @Override
    public int compareTo(Persn persn) {
        long primaryKey = persn.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Persn)) {
            return false;
        }

        Persn persn = (Persn) obj;

        long primaryKey = persn.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        PersnModelImpl persnModelImpl = this;

        persnModelImpl._originalPersnUserId = persnModelImpl._persnUserId;

        persnModelImpl._setOriginalPersnUserId = false;

        persnModelImpl._originalLastName = persnModelImpl._lastName;

        persnModelImpl._originalFirstName = persnModelImpl._firstName;

        persnModelImpl._originalBirthDate = persnModelImpl._birthDate;

        persnModelImpl._originalGender = persnModelImpl._gender;

        persnModelImpl._originalExternalId = persnModelImpl._externalId;

        persnModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Persn> toCacheModel() {
        PersnCacheModel persnCacheModel = new PersnCacheModel();

        persnCacheModel.persnId = getPersnId();

        persnCacheModel.persnUserId = getPersnUserId();

        persnCacheModel.lastName = getLastName();

        String lastName = persnCacheModel.lastName;

        if ((lastName != null) && (lastName.length() == 0)) {
            persnCacheModel.lastName = null;
        }

        persnCacheModel.firstName = getFirstName();

        String firstName = persnCacheModel.firstName;

        if ((firstName != null) && (firstName.length() == 0)) {
            persnCacheModel.firstName = null;
        }

        persnCacheModel.middleName = getMiddleName();

        String middleName = persnCacheModel.middleName;

        if ((middleName != null) && (middleName.length() == 0)) {
            persnCacheModel.middleName = null;
        }

        persnCacheModel.prefix = getPrefix();

        String prefix = persnCacheModel.prefix;

        if ((prefix != null) && (prefix.length() == 0)) {
            persnCacheModel.prefix = null;
        }

        persnCacheModel.suffix = getSuffix();

        String suffix = persnCacheModel.suffix;

        if ((suffix != null) && (suffix.length() == 0)) {
            persnCacheModel.suffix = null;
        }

        Date birthDate = getBirthDate();

        if (birthDate != null) {
            persnCacheModel.birthDate = birthDate.getTime();
        } else {
            persnCacheModel.birthDate = Long.MIN_VALUE;
        }

        Date deceasedDate = getDeceasedDate();

        if (deceasedDate != null) {
            persnCacheModel.deceasedDate = deceasedDate.getTime();
        } else {
            persnCacheModel.deceasedDate = Long.MIN_VALUE;
        }

        persnCacheModel.gender = getGender();

        String gender = persnCacheModel.gender;

        if ((gender != null) && (gender.length() == 0)) {
            persnCacheModel.gender = null;
        }

        persnCacheModel.address = getAddress();

        String address = persnCacheModel.address;

        if ((address != null) && (address.length() == 0)) {
            persnCacheModel.address = null;
        }

        persnCacheModel.address2 = getAddress2();

        String address2 = persnCacheModel.address2;

        if ((address2 != null) && (address2.length() == 0)) {
            persnCacheModel.address2 = null;
        }

        persnCacheModel.city = getCity();

        String city = persnCacheModel.city;

        if ((city != null) && (city.length() == 0)) {
            persnCacheModel.city = null;
        }

        persnCacheModel.state = getState();

        String state = persnCacheModel.state;

        if ((state != null) && (state.length() == 0)) {
            persnCacheModel.state = null;
        }

        persnCacheModel.country = getCountry();

        String country = persnCacheModel.country;

        if ((country != null) && (country.length() == 0)) {
            persnCacheModel.country = null;
        }

        persnCacheModel.zip = getZip();

        String zip = persnCacheModel.zip;

        if ((zip != null) && (zip.length() == 0)) {
            persnCacheModel.zip = null;
        }

        persnCacheModel.phone = getPhone();

        String phone = persnCacheModel.phone;

        if ((phone != null) && (phone.length() == 0)) {
            persnCacheModel.phone = null;
        }

        persnCacheModel.phone2 = getPhone2();

        String phone2 = persnCacheModel.phone2;

        if ((phone2 != null) && (phone2.length() == 0)) {
            persnCacheModel.phone2 = null;
        }

        persnCacheModel.email = getEmail();

        String email = persnCacheModel.email;

        if ((email != null) && (email.length() == 0)) {
            persnCacheModel.email = null;
        }

        persnCacheModel.email2 = getEmail2();

        String email2 = persnCacheModel.email2;

        if ((email2 != null) && (email2.length() == 0)) {
            persnCacheModel.email2 = null;
        }

        persnCacheModel.status = getStatus();

        String status = persnCacheModel.status;

        if ((status != null) && (status.length() == 0)) {
            persnCacheModel.status = null;
        }

        persnCacheModel.source = getSource();

        String source = persnCacheModel.source;

        if ((source != null) && (source.length() == 0)) {
            persnCacheModel.source = null;
        }

        persnCacheModel.externalId = getExternalId();

        String externalId = persnCacheModel.externalId;

        if ((externalId != null) && (externalId.length() == 0)) {
            persnCacheModel.externalId = null;
        }

        persnCacheModel.otherHealthInsurance = getOtherHealthInsurance();

        String otherHealthInsurance = persnCacheModel.otherHealthInsurance;

        if ((otherHealthInsurance != null) &&
                (otherHealthInsurance.length() == 0)) {
            persnCacheModel.otherHealthInsurance = null;
        }

        persnCacheModel.userId = getUserId();

        persnCacheModel.groupId = getGroupId();

        return persnCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(53);

        sb.append("{persnId=");
        sb.append(getPersnId());
        sb.append(", persnUserId=");
        sb.append(getPersnUserId());
        sb.append(", lastName=");
        sb.append(getLastName());
        sb.append(", firstName=");
        sb.append(getFirstName());
        sb.append(", middleName=");
        sb.append(getMiddleName());
        sb.append(", prefix=");
        sb.append(getPrefix());
        sb.append(", suffix=");
        sb.append(getSuffix());
        sb.append(", birthDate=");
        sb.append(getBirthDate());
        sb.append(", deceasedDate=");
        sb.append(getDeceasedDate());
        sb.append(", gender=");
        sb.append(getGender());
        sb.append(", address=");
        sb.append(getAddress());
        sb.append(", address2=");
        sb.append(getAddress2());
        sb.append(", city=");
        sb.append(getCity());
        sb.append(", state=");
        sb.append(getState());
        sb.append(", country=");
        sb.append(getCountry());
        sb.append(", zip=");
        sb.append(getZip());
        sb.append(", phone=");
        sb.append(getPhone());
        sb.append(", phone2=");
        sb.append(getPhone2());
        sb.append(", email=");
        sb.append(getEmail());
        sb.append(", email2=");
        sb.append(getEmail2());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", source=");
        sb.append(getSource());
        sb.append(", externalId=");
        sb.append(getExternalId());
        sb.append(", otherHealthInsurance=");
        sb.append(getOtherHealthInsurance());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(82);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Persn");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>persnId</column-name><column-value><![CDATA[");
        sb.append(getPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>persnUserId</column-name><column-value><![CDATA[");
        sb.append(getPersnUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>lastName</column-name><column-value><![CDATA[");
        sb.append(getLastName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>firstName</column-name><column-value><![CDATA[");
        sb.append(getFirstName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>middleName</column-name><column-value><![CDATA[");
        sb.append(getMiddleName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>prefix</column-name><column-value><![CDATA[");
        sb.append(getPrefix());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>suffix</column-name><column-value><![CDATA[");
        sb.append(getSuffix());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>birthDate</column-name><column-value><![CDATA[");
        sb.append(getBirthDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>deceasedDate</column-name><column-value><![CDATA[");
        sb.append(getDeceasedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>gender</column-name><column-value><![CDATA[");
        sb.append(getGender());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address</column-name><column-value><![CDATA[");
        sb.append(getAddress());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address2</column-name><column-value><![CDATA[");
        sb.append(getAddress2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>city</column-name><column-value><![CDATA[");
        sb.append(getCity());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>state</column-name><column-value><![CDATA[");
        sb.append(getState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>country</column-name><column-value><![CDATA[");
        sb.append(getCountry());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>zip</column-name><column-value><![CDATA[");
        sb.append(getZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone</column-name><column-value><![CDATA[");
        sb.append(getPhone());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone2</column-name><column-value><![CDATA[");
        sb.append(getPhone2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>email</column-name><column-value><![CDATA[");
        sb.append(getEmail());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>email2</column-name><column-value><![CDATA[");
        sb.append(getEmail2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>source</column-name><column-value><![CDATA[");
        sb.append(getSource());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>externalId</column-name><column-value><![CDATA[");
        sb.append(getExternalId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>otherHealthInsurance</column-name><column-value><![CDATA[");
        sb.append(getOtherHealthInsurance());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
