package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.ClSoc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing ClSoc in entity cache.
 *
 * @author caret
 * @see ClSoc
 * @generated
 */
public class ClSocCacheModel implements CacheModel<ClSoc>, Externalizable {
    public long clSocId;
    public long callId;
    public long persnId;
    public String surveyStatus;
    public String surveyComment;
    public long creationDate;
    public String attemptNum;
    public String callerAvailable;
    public String requestedCallbackTime;
    public String willingToAnsQues;
    public String calledCsl;
    public String cslKnowledgable;
    public String cslSupportive;
    public String localResSuggested;
    public String localResContacted;
    public String rsnLocalResNotContacted;
    public String localResHelpful;
    public String concernsAnswered;
    public String understandNextSteps;
    public String callCslAgain;
    public String recommendCsl;
    public String suggestions;
    public String followupCall;
    public String followupCallTime;
    public String tresholdMet;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(51);

        sb.append("{clSocId=");
        sb.append(clSocId);
        sb.append(", callId=");
        sb.append(callId);
        sb.append(", persnId=");
        sb.append(persnId);
        sb.append(", surveyStatus=");
        sb.append(surveyStatus);
        sb.append(", surveyComment=");
        sb.append(surveyComment);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", attemptNum=");
        sb.append(attemptNum);
        sb.append(", callerAvailable=");
        sb.append(callerAvailable);
        sb.append(", requestedCallbackTime=");
        sb.append(requestedCallbackTime);
        sb.append(", willingToAnsQues=");
        sb.append(willingToAnsQues);
        sb.append(", calledCsl=");
        sb.append(calledCsl);
        sb.append(", cslKnowledgable=");
        sb.append(cslKnowledgable);
        sb.append(", cslSupportive=");
        sb.append(cslSupportive);
        sb.append(", localResSuggested=");
        sb.append(localResSuggested);
        sb.append(", localResContacted=");
        sb.append(localResContacted);
        sb.append(", rsnLocalResNotContacted=");
        sb.append(rsnLocalResNotContacted);
        sb.append(", localResHelpful=");
        sb.append(localResHelpful);
        sb.append(", concernsAnswered=");
        sb.append(concernsAnswered);
        sb.append(", understandNextSteps=");
        sb.append(understandNextSteps);
        sb.append(", callCslAgain=");
        sb.append(callCslAgain);
        sb.append(", recommendCsl=");
        sb.append(recommendCsl);
        sb.append(", suggestions=");
        sb.append(suggestions);
        sb.append(", followupCall=");
        sb.append(followupCall);
        sb.append(", followupCallTime=");
        sb.append(followupCallTime);
        sb.append(", tresholdMet=");
        sb.append(tresholdMet);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public ClSoc toEntityModel() {
        ClSocImpl clSocImpl = new ClSocImpl();

        clSocImpl.setClSocId(clSocId);
        clSocImpl.setCallId(callId);
        clSocImpl.setPersnId(persnId);

        if (surveyStatus == null) {
            clSocImpl.setSurveyStatus(StringPool.BLANK);
        } else {
            clSocImpl.setSurveyStatus(surveyStatus);
        }

        if (surveyComment == null) {
            clSocImpl.setSurveyComment(StringPool.BLANK);
        } else {
            clSocImpl.setSurveyComment(surveyComment);
        }

        if (creationDate == Long.MIN_VALUE) {
            clSocImpl.setCreationDate(null);
        } else {
            clSocImpl.setCreationDate(new Date(creationDate));
        }

        if (attemptNum == null) {
            clSocImpl.setAttemptNum(StringPool.BLANK);
        } else {
            clSocImpl.setAttemptNum(attemptNum);
        }

        if (callerAvailable == null) {
            clSocImpl.setCallerAvailable(StringPool.BLANK);
        } else {
            clSocImpl.setCallerAvailable(callerAvailable);
        }

        if (requestedCallbackTime == null) {
            clSocImpl.setRequestedCallbackTime(StringPool.BLANK);
        } else {
            clSocImpl.setRequestedCallbackTime(requestedCallbackTime);
        }

        if (willingToAnsQues == null) {
            clSocImpl.setWillingToAnsQues(StringPool.BLANK);
        } else {
            clSocImpl.setWillingToAnsQues(willingToAnsQues);
        }

        if (calledCsl == null) {
            clSocImpl.setCalledCsl(StringPool.BLANK);
        } else {
            clSocImpl.setCalledCsl(calledCsl);
        }

        if (cslKnowledgable == null) {
            clSocImpl.setCslKnowledgable(StringPool.BLANK);
        } else {
            clSocImpl.setCslKnowledgable(cslKnowledgable);
        }

        if (cslSupportive == null) {
            clSocImpl.setCslSupportive(StringPool.BLANK);
        } else {
            clSocImpl.setCslSupportive(cslSupportive);
        }

        if (localResSuggested == null) {
            clSocImpl.setLocalResSuggested(StringPool.BLANK);
        } else {
            clSocImpl.setLocalResSuggested(localResSuggested);
        }

        if (localResContacted == null) {
            clSocImpl.setLocalResContacted(StringPool.BLANK);
        } else {
            clSocImpl.setLocalResContacted(localResContacted);
        }

        if (rsnLocalResNotContacted == null) {
            clSocImpl.setRsnLocalResNotContacted(StringPool.BLANK);
        } else {
            clSocImpl.setRsnLocalResNotContacted(rsnLocalResNotContacted);
        }

        if (localResHelpful == null) {
            clSocImpl.setLocalResHelpful(StringPool.BLANK);
        } else {
            clSocImpl.setLocalResHelpful(localResHelpful);
        }

        if (concernsAnswered == null) {
            clSocImpl.setConcernsAnswered(StringPool.BLANK);
        } else {
            clSocImpl.setConcernsAnswered(concernsAnswered);
        }

        if (understandNextSteps == null) {
            clSocImpl.setUnderstandNextSteps(StringPool.BLANK);
        } else {
            clSocImpl.setUnderstandNextSteps(understandNextSteps);
        }

        if (callCslAgain == null) {
            clSocImpl.setCallCslAgain(StringPool.BLANK);
        } else {
            clSocImpl.setCallCslAgain(callCslAgain);
        }

        if (recommendCsl == null) {
            clSocImpl.setRecommendCsl(StringPool.BLANK);
        } else {
            clSocImpl.setRecommendCsl(recommendCsl);
        }

        if (suggestions == null) {
            clSocImpl.setSuggestions(StringPool.BLANK);
        } else {
            clSocImpl.setSuggestions(suggestions);
        }

        if (followupCall == null) {
            clSocImpl.setFollowupCall(StringPool.BLANK);
        } else {
            clSocImpl.setFollowupCall(followupCall);
        }

        if (followupCallTime == null) {
            clSocImpl.setFollowupCallTime(StringPool.BLANK);
        } else {
            clSocImpl.setFollowupCallTime(followupCallTime);
        }

        if (tresholdMet == null) {
            clSocImpl.setTresholdMet(StringPool.BLANK);
        } else {
            clSocImpl.setTresholdMet(tresholdMet);
        }

        clSocImpl.resetOriginalValues();

        return clSocImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        clSocId = objectInput.readLong();
        callId = objectInput.readLong();
        persnId = objectInput.readLong();
        surveyStatus = objectInput.readUTF();
        surveyComment = objectInput.readUTF();
        creationDate = objectInput.readLong();
        attemptNum = objectInput.readUTF();
        callerAvailable = objectInput.readUTF();
        requestedCallbackTime = objectInput.readUTF();
        willingToAnsQues = objectInput.readUTF();
        calledCsl = objectInput.readUTF();
        cslKnowledgable = objectInput.readUTF();
        cslSupportive = objectInput.readUTF();
        localResSuggested = objectInput.readUTF();
        localResContacted = objectInput.readUTF();
        rsnLocalResNotContacted = objectInput.readUTF();
        localResHelpful = objectInput.readUTF();
        concernsAnswered = objectInput.readUTF();
        understandNextSteps = objectInput.readUTF();
        callCslAgain = objectInput.readUTF();
        recommendCsl = objectInput.readUTF();
        suggestions = objectInput.readUTF();
        followupCall = objectInput.readUTF();
        followupCallTime = objectInput.readUTF();
        tresholdMet = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(clSocId);
        objectOutput.writeLong(callId);
        objectOutput.writeLong(persnId);

        if (surveyStatus == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(surveyStatus);
        }

        if (surveyComment == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(surveyComment);
        }

        objectOutput.writeLong(creationDate);

        if (attemptNum == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(attemptNum);
        }

        if (callerAvailable == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callerAvailable);
        }

        if (requestedCallbackTime == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(requestedCallbackTime);
        }

        if (willingToAnsQues == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(willingToAnsQues);
        }

        if (calledCsl == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(calledCsl);
        }

        if (cslKnowledgable == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cslKnowledgable);
        }

        if (cslSupportive == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cslSupportive);
        }

        if (localResSuggested == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(localResSuggested);
        }

        if (localResContacted == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(localResContacted);
        }

        if (rsnLocalResNotContacted == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(rsnLocalResNotContacted);
        }

        if (localResHelpful == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(localResHelpful);
        }

        if (concernsAnswered == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(concernsAnswered);
        }

        if (understandNextSteps == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(understandNextSteps);
        }

        if (callCslAgain == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callCslAgain);
        }

        if (recommendCsl == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(recommendCsl);
        }

        if (suggestions == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(suggestions);
        }

        if (followupCall == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(followupCall);
        }

        if (followupCallTime == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(followupCallTime);
        }

        if (tresholdMet == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(tresholdMet);
        }
    }
}
