package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BgNum;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BgNum in entity cache.
 *
 * @author caret
 * @see BgNum
 * @generated
 */
public class BgNumCacheModel implements CacheModel<BgNum>, Externalizable {
    public long bgNumId;
    public long ownerId;
    public long boxGpId;
    public double value;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgNumId=");
        sb.append(bgNumId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", boxGpId=");
        sb.append(boxGpId);
        sb.append(", value=");
        sb.append(value);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public BgNum toEntityModel() {
        BgNumImpl bgNumImpl = new BgNumImpl();

        bgNumImpl.setBgNumId(bgNumId);
        bgNumImpl.setOwnerId(ownerId);
        bgNumImpl.setBoxGpId(boxGpId);
        bgNumImpl.setValue(value);

        bgNumImpl.resetOriginalValues();

        return bgNumImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        bgNumId = objectInput.readLong();
        ownerId = objectInput.readLong();
        boxGpId = objectInput.readLong();
        value = objectInput.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(bgNumId);
        objectOutput.writeLong(ownerId);
        objectOutput.writeLong(boxGpId);
        objectOutput.writeDouble(value);
    }
}
