package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BgLae;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BgLae in entity cache.
 *
 * @author caret
 * @see BgLae
 * @generated
 */
public class BgLaeCacheModel implements CacheModel<BgLae>, Externalizable {
    public long bgLaeId;
    public long ownerId;
    public long boxGpId;
    public String largeText;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgLaeId=");
        sb.append(bgLaeId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", boxGpId=");
        sb.append(boxGpId);
        sb.append(", largeText=");
        sb.append(largeText);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public BgLae toEntityModel() {
        BgLaeImpl bgLaeImpl = new BgLaeImpl();

        bgLaeImpl.setBgLaeId(bgLaeId);
        bgLaeImpl.setOwnerId(ownerId);
        bgLaeImpl.setBoxGpId(boxGpId);

        if (largeText == null) {
            bgLaeImpl.setLargeText(StringPool.BLANK);
        } else {
            bgLaeImpl.setLargeText(largeText);
        }

        bgLaeImpl.resetOriginalValues();

        return bgLaeImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        bgLaeId = objectInput.readLong();
        ownerId = objectInput.readLong();
        boxGpId = objectInput.readLong();
        largeText = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(bgLaeId);
        objectOutput.writeLong(ownerId);
        objectOutput.writeLong(boxGpId);

        if (largeText == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(largeText);
        }
    }
}
