package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Assmt;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Assmt in entity cache.
 *
 * @author caret
 * @see Assmt
 * @generated
 */
public class AssmtCacheModel implements CacheModel<Assmt>, Externalizable {
    public long assmtId;
    public long vcgId;
    public long noteId;
    public long completionDate;
    public String type;
    public long scheduleDate;
    public long userId;
    public String comment;
    public boolean active;
    public long caregiverId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(21);

        sb.append("{assmtId=");
        sb.append(assmtId);
        sb.append(", vcgId=");
        sb.append(vcgId);
        sb.append(", noteId=");
        sb.append(noteId);
        sb.append(", completionDate=");
        sb.append(completionDate);
        sb.append(", type=");
        sb.append(type);
        sb.append(", scheduleDate=");
        sb.append(scheduleDate);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", comment=");
        sb.append(comment);
        sb.append(", active=");
        sb.append(active);
        sb.append(", caregiverId=");
        sb.append(caregiverId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Assmt toEntityModel() {
        AssmtImpl assmtImpl = new AssmtImpl();

        assmtImpl.setAssmtId(assmtId);
        assmtImpl.setVcgId(vcgId);
        assmtImpl.setNoteId(noteId);

        if (completionDate == Long.MIN_VALUE) {
            assmtImpl.setCompletionDate(null);
        } else {
            assmtImpl.setCompletionDate(new Date(completionDate));
        }

        if (type == null) {
            assmtImpl.setType(StringPool.BLANK);
        } else {
            assmtImpl.setType(type);
        }

        if (scheduleDate == Long.MIN_VALUE) {
            assmtImpl.setScheduleDate(null);
        } else {
            assmtImpl.setScheduleDate(new Date(scheduleDate));
        }

        assmtImpl.setUserId(userId);

        if (comment == null) {
            assmtImpl.setComment(StringPool.BLANK);
        } else {
            assmtImpl.setComment(comment);
        }

        assmtImpl.setActive(active);
        assmtImpl.setCaregiverId(caregiverId);

        assmtImpl.resetOriginalValues();

        return assmtImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        assmtId = objectInput.readLong();
        vcgId = objectInput.readLong();
        noteId = objectInput.readLong();
        completionDate = objectInput.readLong();
        type = objectInput.readUTF();
        scheduleDate = objectInput.readLong();
        userId = objectInput.readLong();
        comment = objectInput.readUTF();
        active = objectInput.readBoolean();
        caregiverId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(assmtId);
        objectOutput.writeLong(vcgId);
        objectOutput.writeLong(noteId);
        objectOutput.writeLong(completionDate);

        if (type == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(type);
        }

        objectOutput.writeLong(scheduleDate);
        objectOutput.writeLong(userId);

        if (comment == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(comment);
        }

        objectOutput.writeBoolean(active);
        objectOutput.writeLong(caregiverId);
    }
}
