package gov.va.caret.hook.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.model.Website;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserService;
import com.liferay.portal.service.UserServiceWrapper;
import com.liferay.portlet.announcements.model.AnnouncementsDelivery;

import gov.va.caret.service.PersnLocalServiceUtil;

import java.util.List;
import java.util.Locale;

public class UserPersnServiceImpl extends UserServiceWrapper {
	
	UserService userService;
	
	public UserPersnServiceImpl(UserService userService) {
		super(userService);
		this.userService = userService;
	}
	
	/**
	* Adds a user.
	*
	* <p>
	* This method handles the creation and bookkeeping of the user including
	* its resources, metadata, and internal data structures. It is not
	* necessary to make subsequent calls to any methods to setup default
	* groups, resources, etc.
	* </p>
	*
	* @param companyId the primary key of the user's company
	* @param autoPassword whether a password should be automatically generated
	for the user
	* @param password1 the user's password
	* @param password2 the user's password confirmation
	* @param autoScreenName whether a screen name should be automatically
	generated for the user
	* @param screenName the user's screen name
	* @param emailAddress the user's email address
	* @param facebookId the user's facebook ID
	* @param openId the user's OpenID
	* @param locale the user's locale
	* @param firstName the user's first name
	* @param middleName the user's middle name
	* @param lastName the user's last name
	* @param prefixId the user's name prefix ID
	* @param suffixId the user's name suffix ID
	* @param male whether the user is male
	* @param birthdayMonth the user's birthday month (0-based, meaning 0 for
	January)
	* @param birthdayDay the user's birthday day
	* @param birthdayYear the user's birthday year
	* @param jobTitle the user's job title
	* @param groupIds the primary keys of the user's groups
	* @param organizationIds the primary keys of the user's organizations
	* @param roleIds the primary keys of the roles this user possesses
	* @param userGroupIds the primary keys of the user's user groups
	* @param sendEmail whether to send the user an email notification about
	their new account
	* @param serviceContext the service context to be applied (optionally
	<code>null</code>). Can set the UUID (with the <code>uuid</code>
	attribute), asset category IDs, asset tag names, and expando
	bridge attributes for the user.
	* @return the new user
	* @throws PortalException if the user's information was invalid, if the
	operation was not allowed by the membership policy, if the
	creator did not have permission to add users, or if the email
	address was reserved
	* @throws SystemException if a system exception occurred
	*/
	@Override
	public com.liferay.portal.model.User addUser(long l0, boolean b0, String s0, String s1, boolean b2, String s3, String s4, long l2, String s5, 
								Locale l1, String s6, String s7, String s8, int i0, int i2, boolean b3,
								int i3, int i4, int i5, String s9, long[] ll0, long[] ll1, long[] ll2,
								long[] ll3, boolean s10, ServiceContext sc) throws PortalException, SystemException {
		
		User user = super.addUser( l0,  b0,  s0,  s1,  b2,  s3,  s4,  l2,  s5, 
				 l1,  s6,  s7,  s8,  i0,  i2,  b3,
				 i3,  i4,  i5,  s9,  ll0,  ll1,  ll2,
				 ll3,  s10, sc);
		
		createPersn( user );
		user.setPasswordReset(false);
		userService.updateStatus(user.getUserId(), 0, sc);
		
		return user;
	}

	/**
	* Adds a user with additional parameters.
	*
	* <p>
	* This method handles the creation and bookkeeping of the user including
	* its resources, metadata, and internal data structures. It is not
	* necessary to make subsequent calls to any methods to setup default
	* groups, resources, etc.
	* </p>
	*
	* @param companyId the primary key of the user's company
	* @param autoPassword whether a password should be automatically generated
	for the user
	* @param password1 the user's password
	* @param password2 the user's password confirmation
	* @param autoScreenName whether a screen name should be automatically
	generated for the user
	* @param screenName the user's screen name
	* @param emailAddress the user's email address
	* @param facebookId the user's facebook ID
	* @param openId the user's OpenID
	* @param locale the user's locale
	* @param firstName the user's first name
	* @param middleName the user's middle name
	* @param lastName the user's last name
	* @param prefixId the user's name prefix ID
	* @param suffixId the user's name suffix ID
	* @param male whether the user is male
	* @param birthdayMonth the user's birthday month (0-based, meaning 0 for
	January)
	* @param birthdayDay the user's birthday day
	* @param birthdayYear the user's birthday year
	* @param jobTitle the user's job title
	* @param groupIds the primary keys of the user's groups
	* @param organizationIds the primary keys of the user's organizations
	* @param roleIds the primary keys of the roles this user possesses
	* @param userGroupIds the primary keys of the user's user groups
	* @param addresses the user's addresses
	* @param emailAddresses the user's email addresses
	* @param phones the user's phone numbers
	* @param websites the user's websites
	* @param announcementsDelivers the announcements deliveries
	* @param sendEmail whether to send the user an email notification about
	their new account
	* @param serviceContext the service context to be applied (optionally
	<code>null</code>). Can set the UUID (with the <code>uuid</code>
	attribute), asset category IDs, asset tag names, and expando
	bridge attributes for the user.
	* @return the new user
	* @throws PortalException if the user's information was invalid, if the
	creator did not have permission to add users, if the email
	address was reserved, if the operation was not allowed by the
	membership policy, or if some other portal exception occurred
	* @throws SystemException if a system exception occurred
	*/
	@Override
	public com.liferay.portal.model.User addUser(long l0, boolean b0, String s0, String s1, boolean b1, String s2, String s3, long l2,
			String s4, Locale l, String s5, String s6, String s7, int i0, int i1, boolean b2, int i3,
			int i4, int i5, String s8, long[] ll0, long[] ll1, long[] ll2, long[] ll3, List<Address> a,
			List<EmailAddress> e, List<Phone> p, List<Website> w, List<AnnouncementsDelivery> ad, boolean b, ServiceContext sc) throws PortalException, SystemException{
		
		User user = super.addUser( l0,  b0,  s0,  s1,  b1,  s2,  s3,  l2,
				 s4,  l,  s5,  s6,  s7,  i0,  i1,  b2,  i3,
				 i4,  i5,  s8,  ll0,  ll1,  ll2,  ll3, a,
				e, p, w, ad,  b, sc );
		
		user.setPasswordReset(false);
		userService.updateStatus(user.getUserId(), 0, sc);
		
		createPersn(user);
		return user;
	}
	
	private void createPersn(User user) throws PortalException, SystemException {
		
		ServiceContextThreadLocal.getServiceContext();
		_log.debug ( "adding persn " + user.getFullName() );
		PersnLocalServiceUtil.addPersn(user, false);		
	}

	/**
	* Updates the user's workflow status.
	*
	* @param userId the primary key of the user
	* @param status the user's new workflow status
	* @param serviceContext the service context to be applied. You can specify
	an unencrypted custom password (used by an LDAP listener) for the
	user via attribute <code>passwordUnencrypted</code>.
	* @return the user
	* @throws PortalException if a user with the primary key could not be
	found, if the current user was updating her own status to
	anything but {@link
	com.liferay.portal.kernel.workflow.WorkflowConstants#STATUS_APPROVED},
	or if the current user did not have permission to update the
	user's workflow status.
	* @throws SystemException if a system exception occurred
	*/
	@Override
	public com.liferay.portal.model.User updateStatus(long userId, int status,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		int oldStatus = UserLocalServiceUtil.getUser(userId).getStatus();
		User user = super.updateStatus(userId, status, serviceContext);
		
		if ( oldStatus == WorkflowConstants.STATUS_INACTIVE || status == WorkflowConstants.STATUS_INACTIVE ){
			//PersnLocalServiceUtil.updateStatus(userId, status, serviceContext);
		}
		
		return user;
	}
	
	private static Log _log = LogFactoryUtil.getLog(UserPersnServiceImpl.class);
	
}
