package gov.va.caret.hook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;


public class LogoutPage extends Action {

	private static final Log _log = LogFactoryUtil.getLog(LogoutPage.class);
	private static final String LOG_OUT_URL = "logout.url";
	private static final String LOG_OUT_URL_ONLINE = "logout.url.online";
	
	public void run(HttpServletRequest request, HttpServletResponse resp) throws ActionException {
		
		LastPath lastpath = (LastPath) request.getSession().getAttribute(WebKeys.LAST_PATH);
		if ( lastpath != null ){
			_log.info( "CaretLogoutPreAction" + lastpath.getPath() );
			request.setAttribute( WebKeys.REFERER, PropsUtil.get(LOG_OUT_URL + lastpath.getPath().replace(StringPool.FORWARD_SLASH, StringPool.PERIOD) ) );
		} else {
			request.setAttribute( WebKeys.REFERER, PropsUtil.get( LOG_OUT_URL_ONLINE  ) );
			_log.warn("lastpath is null");
		}
	}
}

