package gov.va.caret.controller.dashboard.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pm.portlet.PMPortlet;
import gov.va.caret.security.CAction;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;


public abstract class DashboardConfig implements Serializable {

	private static final long serialVersionUID = 21221212121L;
	protected EnabledSearch enabledSearch;
	protected GenericReport[] reports;
	protected String role;
	protected long roleId;
	protected long userId;
	protected long companyId;
	
	public String getRole() {
		return role;
	}
	
	public long getRoleId() {
		return roleId;
	}

	public void setRole(String role) {
		this.role = role;
	}

	public abstract String getView ();
	public abstract CAction.CaretCan[] getCreateActions();
	public abstract CAction.CaretCan[] getToolsActions();
	
	public EnabledSearch getEnabledSearch() {
		return enabledSearch;
	}
	public GenericReport[] getReports() {
		return reports;
	}

	public void setRoleId( long roleId ) {
		this.roleId = roleId;		
	}
	
	public GenericReport getReport (String name){
		for ( GenericReport report: enabledSearch.getCachedReports() ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
		}
		for ( GenericReport report: reports ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
		}
		return null;
	}

	public Object getMenu(PortletRequest renderRequest) {
		Map<String,String> createActions = new TreeMap<String,String>();
		Locale locale = LocaleUtil.getDefault();
		for ( CAction.CaretCan canDo: getCreateActions() ){
			if ( CAction.canDoCaret( renderRequest, canDo.name() ) ){
				createActions.put( canDo.name(), LanguageUtil.get( locale, canDo.toString() ));
			}
		}
		
		Map<String,String> toolsActions = new TreeMap<String,String>();
		for ( CAction.CaretCan canDo: getToolsActions() ){
			if ( CAction.canDoCaret( renderRequest, canDo.name() ) ){
				toolsActions.put( canDo.name(), LanguageUtil.get( locale, canDo.toString() ) );
			}
		}
		Map<String,String> messsageActions = new TreeMap<String,String>();
		if(CAction.canDoCaret(renderRequest, CAction.CaretCan.INTERNAL_MESSAGE)) {
			Long userId= PortalUtil.getUserId(renderRequest);
			messsageActions.put(CAction.CaretCan.INTERNAL_MESSAGE.name(), Integer.toString(PMPortlet.getUnreadCount(userId)));
		}
		
		Map<String,Map<String,String>> menu = new HashMap<String, Map<String,String>>();
		if ( !createActions.isEmpty() ){
			menu.put("createActions", createActions);
		}
		if ( !toolsActions.isEmpty() ){
			menu.put("toolsActions", toolsActions);
		}
		if ( !messsageActions.isEmpty() ){
			menu.put("messageActions", messsageActions);
		}
		
		if ( menu.isEmpty() ){
			return null;
		}
			
		return menu;
	}
	
	void loadReports ( PortletRequest renderRequest )  throws ApplicationWorkFlowException {
		
		this.userId = PortalUtil.getUserId( renderRequest );
		this.companyId = PortalUtil.getCompanyId( renderRequest );
		for ( GenericReport report: reports ){
			if ( report instanceof CachedReport || report instanceof AdhocReport ) continue;
			loadReport(report, renderRequest);
		}
		ResultMap.getCaretMap(renderRequest).put("context", "dashboard");
		ResultMap.getCaretMap(renderRequest).put("searchForm", renderRequest.getPortletSession().getAttribute("searchForm"));
	}

	protected void loadReport(GenericReport report, PortletRequest renderRequest) throws ApplicationWorkFlowException {
		Object reportParams = CaretParam.getParameter( renderRequest, report.getParameterNames() );
		_log.debug( report.getName() );
		int count = CaretLocalServiceUtil.getReportCount( report.getName(), reportParams );
		ResultMap.getResultTotalMap( renderRequest ).put( report.getName(), count );
		
		if ( count > 0 && !report.isLazy() ){
			
			int cur = ParamUtil.getInteger(renderRequest, SearchContainer.DEFAULT_CUR_PARAM );
			int delta = ParamUtil.getInteger(renderRequest, SearchContainer.DEFAULT_DELTA_PARAM, SearchContainer.DEFAULT_DELTA);
			int start = ( cur == 0 )? 0 : delta * ( cur-1 );
			int end = ( cur == 0 )? delta : ( delta * cur );
			
			report.run(renderRequest, false, start, end);
		}
	}

	//default dashboard for Portal-Admin... HEC_FUNCTION
	public static DashboardConfig getOmniDashboard() {
		try {
			return DashboardType.HEC_FUNCTION.dashboardConfig.newInstance();
		} catch (InstantiationException e) {
			_log.error("unable super 1");
			ApplicationWorkFlowException.handleException(e);
		} catch (IllegalAccessException e) {
			_log.error("unable super 2");
			ApplicationWorkFlowException.handleException(e);
		}
		_log.info("No dashboard created...");
		return null;
	}
	
	public Collection<WorkType> getEnabledWork() {
		return Collections.emptyList();
	}
	
	public String getQueueIds() {
		return "-1";
	}
	
	public Map<String, Long> getAssignees(WorkItemSupport workItem) {
		return Collections.emptyMap();
	}
	
	protected static Log _log = LogFactoryUtil.getLog(DashboardConfig.class);

	public boolean canAssign(WorkType workType) {
		return getEnabledWork().contains(workType);
	}

}
