package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.letters.CscLetterType;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;
import gov.va.caret.workflow.OwnerQueue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

public class CscDashboardConfig extends FacilityDashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6732888370712702769L;
	public final String VIEW = "/jsp/dashboard/csc.jsp";
	protected Map<Long,Facil> facilities;
	private String visnGroupIds; 
	
	final static GenericReport APP_DELAYS_WORK = new GenericReport("appDelays", true, "creationDate", true, GenericReport.VISN_QUERY_NDX, ReportParameter.visnGroupIds );
	
	public CscDashboardConfig() {
		super();
		
		this.reports = new GenericReport[]{ 
				new GenericReport("unassignedWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ), 
				new GenericReport("myApplicationWork", true, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
				new GenericReport("correctionWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ),
				new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
				
				new GenericReport("newApplications", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ) ,
				new GenericReport("inProcess", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId  ),
				new GenericReport("transferred", true, "creationDate", true, ReportParameter.queId, ReportParameter.queId ) ,
				new GenericReport("dueTodayWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ), 
				new GenericReport("overdueApps", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ) ,
				new GenericReport("overdueInProcess", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ),
				new GenericReport("homeVisit", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ),
				//new GenericReport("homeVisit", true, "creationDate", true ),
				new GenericReport("deathNotice", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ),
				new AdhocReport("vcgNotes", ReportParameter.classPk ),
				new GenericReport("referralWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ) ,
				new GenericReport("vcgNotifications", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ),
				new GenericReport("tiuNoteRewrite", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.userOrgIds ),
				new GenericReport("periodicAssessments", true, "scheduleDate", true, 4, ReportParameter.userOrgIds, ReportParameter.userOrgIds ),
				new CachedReport("persnAudit"),
				new CachedReport("persn"),
				new CachedReport("workAudit"),
				new CachedReport("vcgAudit"),
				new CachedReport("assmtAudit"),
				new CachedReport("assmtAuditAll"),
				new CachedReport("assmtAuditPeriodicAll"),
				new CachedReport("periodicAssessmentsAll"),
				new CachedReport("vcgSupportingDocsAll"),
				new CachedReport("vcgOpenRefs"),
				new CachedReport("vcgClosedRefs"),
				new CachedReport("vcgOpenWork"),
				new CachedReport("vcgClosedWork"),
				new CachedReport("vcgDocsHistoryAll")
			};
		
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems") );
	}
	
	public CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			//CAction.CaretCan.CREATE_MESSAGES,
			CAction.CaretCan.CREATE_APPLICATIONS,
			CAction.CaretCan.SET_GENERAL_CG
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR,
				CAction.CaretCan.IDENTITY_MATCHING
			};
	}
	
	public final CAction.CaretCan[] getMessageActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.INTERNAL_MESSAGE
		};
	}
	

	@Override
	public String getView() {
		return VIEW;
	}
	public void setFacilityId( long facilityId ){}
	
	public Set<Long> getGroupId(){
		return groupId;
	}
	public Set<Long> getVisnId(){
		return visnId;
	}
	//Filter
	public Map<Long,Facil> getFacilities(){
		return facilities;
	}
	public void setFacilities(Map<Long,Facil> facilities){
		this.facilities = facilities;
	}
	
	public void setUsers(PortletRequest request, List<Role> roles ) throws ApplicationWorkFlowException {
		@SuppressWarnings("unchecked")
		Map<String,Long> userMap = (Map<String,Long>)request.getPortletSession().getAttribute(CaretStrPool.USERMAP);
		if ( userMap == null ) {
			userMap = new TreeMap<String,Long>();
		}
		
		if ( userMap.isEmpty() ){
			List<String> list = Arrays.asList(PortletProps.getArray( CaretStrPool.CSC_ASSIGNABLE_ROLES ) ); 
			for ( Role role: roles ){
				if ( list.contains( role.getName() ) ){
					try {
						List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
						for ( User user: users ){
//							if ( userIds.contains( user.getUserId() ) ){
								userMap.put(user.getFullName(), user.getUserId() );
//							}
						}
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
			}
			request.getPortletSession().setAttribute(CaretStrPool.USERMAP, userMap);
		}
	}

	@Override
	public void initDashBoard(PortletRequest request) throws ApplicationWorkFlowException {
		List<Role> roles;
		try {
			roles = RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) );
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
			_log.error("unable to init(2)");
			return;
		}
		setFacilities( CaretParam.getFacilities(request) );
		// setUsers( request, roles );
		request.setAttribute("cgRoles", new String[]{"caller"});
		if ( CAction.canDoCaret(request, CaretCan.VACO_FUNCTION) ){
			Set<GenericReport> reportQues = new LinkedHashSet<GenericReport>();
			reportQues.addAll( Arrays.asList(this.reports) );
			reportQues.add(APP_DELAYS_WORK);
			this.reports = reportQues.toArray(new GenericReport[reportQues.size()]);
			this.enabledWork.add(WorkType.APP_DELAY);
		}
	}

	@Override
	public void configureFacility(PortletRequest request) throws ApplicationWorkFlowException {
		String facility = StringPool.BLANK;
		String visn = StringPool.BLANK;
		Map<String,Long> groupIds = new TreeMap<String,Long>();
		StringBuilder sb = new StringBuilder();
		try {
			for( Organization org: OrganizationLocalServiceUtil.getUserOrganizations( PortalUtil.getUserId(request) ) ){
				if ( org.getName().toLowerCase().startsWith("visn") ){
					visnId.add( org.getPrimaryKey() );
					visn = visn + org.getName() + StringPool.COMMA_AND_SPACE;
					for ( Organization descendant : org.getDescendants() ){
						Facil facil = FacilLocalServiceUtil.getByOrgId(descendant.getPrimaryKey());
						groupIds.put( facil.getFacilityNumber() + StringPool.DASH + descendant.getName(), descendant.getOrganizationId() );
						sb.append( descendant.getOrganizationId() ).append(StringPool.COMMA_AND_SPACE);
					}
				} else {
					groupId.add(org.getPrimaryKey());
					Facil facil = FacilLocalServiceUtil.getByOrgId(org.getPrimaryKey());
					groupIds.put( facil.getFacilityNumber() + StringPool.DASH + org.getName(), org.getOrganizationId() );
					facility = facility + facil.getFacilityNumber() + StringPool.DASH + org.getName() + StringPool.COMMA_AND_SPACE ;
				}
			}
			if ( facility.length() > 0 ){
				facility = facility.substring(0, facility.length()-2);
			}
			if ( sb.length() > 2 ){
				visnGroupIds = sb.substring( 0, sb.length()-2 );
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
			
		request.setAttribute("facilityName", facility );
			
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		
		if ( CAction.canDoCaret(request, CaretCan.VACO_FUNCTION) && !visnId.isEmpty() ){
			request.setAttribute("visnName", visn.substring( 0, visn.length()-2 ) );
			caret.put( "visnGroupIds", visnGroupIds );
		}
		if ( CAction.canDoCaret(request, CAction.CaretCan.VISN_CSC_WAIVER_Q ) ){
			request.setAttribute("appDelay", true );
			enabledWork.add( WorkType.APP_DELAY );
		}
		
		caret.put( CaretStrPool.GROUP_ID, groupId );
		caret.put( CaretStrPool.WORKITEM_GROUPS, groupIds );
		caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		caret.put( CaretStrPool.USERMAP, request.getPortletSession().getAttribute(CaretStrPool.USERMAP) );
		caret.put( CaretStrPool.WORKITEM_TYPES, WorkType.getFilterRegistered() );
		
	}

	public String setVisnInfo ( PortletRequest request ) {
		String visn = StringPool.BLANK;
		
		if ( CAction.canDoCaret(request, CaretCan.VACO_FUNCTION) && !visnId.isEmpty() ){
			StringBuilder sb = new StringBuilder();
			try {
				for ( Long vId: visnId ){
					Organization org = OrganizationLocalServiceUtil.getOrganization(vId);
					visn = org.getName() + StringPool.COMMA_AND_SPACE;
					List<Organization> descendants = org.getDescendants();
					if ( descendants != null && !descendants.isEmpty() ){
						for ( Organization organ: descendants ){
							sb.append( organ.getOrganizationId() ).append(StringPool.COMMA_AND_SPACE);
						}
					}
				}
				visnGroupIds = sb.substring( 0, sb.length()-2 );
				visn = visn.substring( 0, visn.length()-2 );
			} catch (SystemException | PortalException e) {
				e.printStackTrace();
			}
		}
		return visn;
	}
	
	public String getVisnGroupIds(){
		return visnGroupIds;
	}
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		super.loadReports( request );
		ResultMap.getCaretMap(request).put(CaretStrPool.USE_WORKTYPES, true);
		ResultMap.getCaretMap(request).put( "cgRoles", new String[]{"primary-cg", "secondary-cg", "secondary-two-cg"} );
		ResultMap.getCaretMap(request).put(CaretStrPool.CSC_LETTER_NAMES, Arrays.asList(CscLetterType.values()));
	}
	
	public Collection<WorkType> getEnabledWork() {
		return enabledWork;
	}
	
	public Map<String, Long> getAssignees(WorkItemSupport workItem) {
		if ( WorkType.APP_DELAY == workItem.getWorkType() && enabledWork.contains( WorkType.APP_DELAY ) ){
			return getAppDelayAssignees();
		} 
		switch ( workItem.getWorkType() ){
			case APPROVED_DISPOSITION:
			case REVOKED_DISPOSITION:
			case REINSTATED_DISPOSITION:
			case TIER_UPDATE:
			case ADDRESS_CHANGE:
			case C_INFO_CHANGE:
			case V_INFO_CHANGE:
				if ( !OwnerQueue.CORRECTION_Q.name().equals( workItem.getStatus() ) ){
					return Collections.emptyMap();
				}
			case CSC_APP:
			case ONLINE_APP:
			case CSC_WAIVER:
			case HOME_VISIT:
			case REFERRAL:
			case CALL_REFERRAL:
			case DELAY_REVIEWED:
			case CSL_REFERRAL:
			case HEC_REFERRAL:
				Map<String,Long> userMap = new TreeMap<String,Long>();
				List<String> list = Arrays.asList(PortletProps.getArray( CaretStrPool.CSC_ASSIGNABLE_ROLES ) ); 
				try {
					for ( Role role: RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) ) ){
						if ( list.contains( role.getName() ) ){
							try {
								List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
								for ( User user: users ){
									userMap.put(user.getFullName(), user.getUserId() );
								}
							} catch (SystemException e) {
								ApplicationWorkFlowException.handleException(e);
							}
						}
					}
				} catch (SystemException e) {
					e.printStackTrace();
				}
				return userMap;
			default:
				return Collections.emptyMap();
		}
	}
	
	public Map<String, Long> getAppDelayAssignees() {
		Map<String,Long> userMap = new TreeMap<String,Long>();
		try {
			Role role = RoleLocalServiceUtil.getRole(companyId, CodifiedRole.getRoleName("VSN_LED") );
			
			List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
			for ( User user: users ){
				if ( user.getUserId() == userId ) continue;
				userMap.put(user.getFullName(), user.getUserId() );
			}
			
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
			return Collections.emptyMap();
		} catch (PortalException e) {
			e.printStackTrace();
		}
		return userMap;
	}
	
	private static Log _log = LogFactoryUtil.getLog( CscDashboardConfig.class );

	@Override
	public Map<String, String> getVisnMap() {
		Map<String, String> map = new HashMap<String, String>();
		map.put("visnGroupIds", visnGroupIds);
		return map;
	}
	

}
