package gov.va.caret.controller.dashboard.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.letters.CbopcLetterType;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.impl.BgNumImpl;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BgNumLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;

public class CbopcFmDashboardConfig extends DashboardConfig {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/cbopcfm.jsp";
	public static final long AVAILABLE_ID = 212l;
	private static final long SCHEDULED_ID = 313l;
	private static final String AVAILABLE = "AVAILABLE";
	private static final String SCHEDULED = "SCHEDULED";
	
	public CbopcFmDashboardConfig() {
		super();
		this.enabledSearch = new EnabledSearch( new CachedReport("blsRates"), new CachedReport("vendors"), new CachedReport("payments") );
		this.reports = new GenericReport[]{ 
								new GenericReport("cbopcStipend"),
								new GenericReport("cbopcPaymentLog")};
	}

	
	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
				CAction.CaretCan.UPDATE_FUNDING,
				CAction.CaretCan.FMS_SERVICE
		};
	}
/*
 * (non-Javadoc)
 * @see gov.va.caret.controller.dashboard.config.DashboardConfig#getToolsActions()
 */
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
	
	public final CAction.CaretCan[] getMessageActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.INTERNAL_MESSAGE
		};
	}

	@Override
	public String getView() {
		return VIEW;
	}
	
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		super.loadReports( request );
		//TODO: Move this to portlet init()...
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		try { //[{bgNumId=637873, ownerId=0, boxGpId=313, value=0.0}, {bgNumId=637874, ownerId=0, boxGpId=313, value=0.0}]
			List<BgNum> list =  BgNumLocalServiceUtil.getBgNums(-1, -1);
			BgNum computed = null, available = null;
			if ( list.isEmpty() ){
				computed = BgNumLocalServiceUtil.fetchBgNum(SCHEDULED_ID);
				if ( computed == null ){
					computed = new BgNumImpl();
					computed.setBoxGpId(SCHEDULED_ID);
					computed.setOwnerId(SCHEDULED_ID);
					computed.setValue(0);
					BgNumLocalServiceUtil.addBgNum(computed);
				}
				available = BgNumLocalServiceUtil.fetchBgNum(AVAILABLE_ID);
				if ( available == null ){
					available = new BgNumImpl();
					available.setBoxGpId(AVAILABLE_ID);
					available.setOwnerId(AVAILABLE_ID);
					available.setValue(0);
					BgNumLocalServiceUtil.addBgNum(available);
				}
			} else {
				for ( BgNum bgNum: list ){
					if ( bgNum.getOwnerId() == AVAILABLE_ID ){
						available = bgNum;
					} else if ( bgNum.getOwnerId() == SCHEDULED_ID ){
						computed = bgNum;
					}
				}
			}
			caret.put(AVAILABLE, available.getValue());
			caret.put(SCHEDULED, computed.getValue());
			
		} catch (SystemException e) {
			e.printStackTrace();
		}
		
		caret.put(CaretStrPool.CBOPC_LETTER_NAMES, Arrays.asList(CbopcLetterType.values()));
	}

}
