package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.WorIm;

/**
 * The persistence interface for the wor im service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see WorImPersistenceImpl
 * @see WorImUtil
 * @generated
 */
public interface WorImPersistence extends BasePersistence<WorIm> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link WorImUtil} to access the wor im persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @return the matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByType(long classPk,
        long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @return the range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByType(long classPk,
        long classId, java.lang.String type, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByType(long classPk,
        long classId, java.lang.String type, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByType_First(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByType_First(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByType_Last(long classPk, long classId,
        java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByType_Last(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the wor ims before and after the current wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param worImId the primary key of the current wor im
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next wor im
    * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm[] findByType_PrevAndNext(long worImId,
        long classPk, long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Removes all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; from the database.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @throws SystemException if a system exception occurred
    */
    public void removeByType(long classPk, long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @return the number of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public int countByType(long classPk, long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @return the matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByGroupTypes(
        long classPk, long classId, java.lang.String type, long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @return the range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByGroupTypes(
        long classPk, long classId, java.lang.String type, long groupId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByGroupTypes(
        long classPk, long classId, java.lang.String type, long groupId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByGroupTypes_First(long classPk,
        long classId, java.lang.String type, long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByGroupTypes_First(long classPk,
        long classId, java.lang.String type, long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByGroupTypes_Last(long classPk,
        long classId, java.lang.String type, long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByGroupTypes_Last(long classPk,
        long classId, java.lang.String type, long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the wor ims before and after the current wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param worImId the primary key of the current wor im
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next wor im
    * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm[] findByGroupTypes_PrevAndNext(
        long worImId, long classPk, long classId, java.lang.String type,
        long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param types the types
    * @param groupId the group ID
    * @return the matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByGroupTypes(
        long classPk, long classId, java.lang.String[] types, long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param types the types
    * @param groupId the group ID
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @return the range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByGroupTypes(
        long classPk, long classId, java.lang.String[] types, long groupId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param types the types
    * @param groupId the group ID
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByGroupTypes(
        long classPk, long classId, java.lang.String[] types, long groupId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63; from the database.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByGroupTypes(long classPk, long classId,
        java.lang.String type, long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param groupId the group ID
    * @return the number of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public int countByGroupTypes(long classPk, long classId,
        java.lang.String type, long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param types the types
    * @param groupId the group ID
    * @return the number of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public int countByGroupTypes(long classPk, long classId,
        java.lang.String[] types, long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @return the matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByUserType(
        long classPk, long classId, java.lang.String type, long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @return the range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByUserType(
        long classPk, long classId, java.lang.String type, long userId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findByUserType(
        long classPk, long classId, java.lang.String type, long userId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByUserType_First(long classPk,
        long classId, java.lang.String type, long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByUserType_First(long classPk,
        long classId, java.lang.String type, long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByUserType_Last(long classPk,
        long classId, java.lang.String type, long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByUserType_Last(long classPk,
        long classId, java.lang.String type, long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the wor ims before and after the current wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param worImId the primary key of the current wor im
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next wor im
    * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm[] findByUserType_PrevAndNext(long worImId,
        long classPk, long classId, java.lang.String type, long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Removes all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63; from the database.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByUserType(long classPk, long classId,
        java.lang.String type, long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param userId the user ID
    * @return the number of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public int countByUserType(long classPk, long classId,
        java.lang.String type, long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; or throws a {@link gov.va.caret.NoSuchWorImException} if it could not be found.
    *
    * @param vcgId the vcg ID
    * @param caregiverId the caregiver ID
    * @param status the status
    * @return the matching wor im
    * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByVcgId(long vcgId, long caregiverId,
        java.lang.String status)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param vcgId the vcg ID
    * @param caregiverId the caregiver ID
    * @param status the status
    * @return the matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByVcgId(long vcgId, long caregiverId,
        java.lang.String status)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param vcgId the vcg ID
    * @param caregiverId the caregiver ID
    * @param status the status
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching wor im, or <code>null</code> if a matching wor im could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByVcgId(long vcgId, long caregiverId,
        java.lang.String status, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; from the database.
    *
    * @param vcgId the vcg ID
    * @param caregiverId the caregiver ID
    * @param status the status
    * @return the wor im that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm removeByVcgId(long vcgId, long caregiverId,
        java.lang.String status)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the number of wor ims where vcgId = &#63; and caregiverId = &#63; and status = &#63;.
    *
    * @param vcgId the vcg ID
    * @param caregiverId the caregiver ID
    * @param status the status
    * @return the number of matching wor ims
    * @throws SystemException if a system exception occurred
    */
    public int countByVcgId(long vcgId, long caregiverId,
        java.lang.String status)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the wor im in the entity cache if it is enabled.
    *
    * @param worIm the wor im
    */
    public void cacheResult(gov.va.caret.model.WorIm worIm);

    /**
    * Caches the wor ims in the entity cache if it is enabled.
    *
    * @param worIms the wor ims
    */
    public void cacheResult(java.util.List<gov.va.caret.model.WorIm> worIms);

    /**
    * Creates a new wor im with the primary key. Does not add the wor im to the database.
    *
    * @param worImId the primary key for the new wor im
    * @return the new wor im
    */
    public gov.va.caret.model.WorIm create(long worImId);

    /**
    * Removes the wor im with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param worImId the primary key of the wor im
    * @return the wor im that was removed
    * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm remove(long worImId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    public gov.va.caret.model.WorIm updateImpl(gov.va.caret.model.WorIm worIm)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the wor im with the primary key or throws a {@link gov.va.caret.NoSuchWorImException} if it could not be found.
    *
    * @param worImId the primary key of the wor im
    * @return the wor im
    * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm findByPrimaryKey(long worImId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWorImException;

    /**
    * Returns the wor im with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param worImId the primary key of the wor im
    * @return the wor im, or <code>null</code> if a wor im with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.WorIm fetchByPrimaryKey(long worImId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the wor ims.
    *
    * @return the wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the wor ims.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @return the range of wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the wor ims.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of wor ims
    * @param end the upper bound of the range of wor ims (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of wor ims
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.WorIm> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the wor ims from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of wor ims.
    *
    * @return the number of wor ims
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
