package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.PayLg;

/**
 * The persistence interface for the pay lg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PayLgPersistenceImpl
 * @see PayLgUtil
 * @generated
 */
public interface PayLgPersistence extends BasePersistence<PayLg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link PayLgUtil} to access the pay lg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the pay lgs where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @return the matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findByPaymentDate(
        java.util.Date paymentDate)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the pay lgs where paymentDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param paymentDate the payment date
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @return the range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findByPaymentDate(
        java.util.Date paymentDate, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the pay lgs where paymentDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param paymentDate the payment date
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findByPaymentDate(
        java.util.Date paymentDate, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg findByPaymentDate_First(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Returns the first pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg fetchByPaymentDate_First(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg findByPaymentDate_Last(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Returns the last pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg fetchByPaymentDate_Last(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the pay lgs before and after the current pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentLogId the primary key of the current pay lg
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg[] findByPaymentDate_PrevAndNext(
        long paymentLogId, java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Removes all the pay lgs where paymentDate = &#63; from the database.
    *
    * @param paymentDate the payment date
    * @throws SystemException if a system exception occurred
    */
    public void removeByPaymentDate(java.util.Date paymentDate)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of pay lgs where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @return the number of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public int countByPaymentDate(java.util.Date paymentDate)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the pay lgs where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @return the matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findByStiPtId(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the pay lgs where stiPtId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiPtId the sti pt ID
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @return the range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findByStiPtId(
        long stiPtId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the pay lgs where stiPtId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiPtId the sti pt ID
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findByStiPtId(
        long stiPtId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg findByStiPtId_First(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Returns the first pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg fetchByStiPtId_First(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg findByStiPtId_Last(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Returns the last pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg fetchByStiPtId_Last(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the pay lgs before and after the current pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param paymentLogId the primary key of the current pay lg
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg[] findByStiPtId_PrevAndNext(
        long paymentLogId, long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Removes all the pay lgs where stiPtId = &#63; from the database.
    *
    * @param stiPtId the sti pt ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByStiPtId(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of pay lgs where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @return the number of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public int countByStiPtId(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the pay lg in the entity cache if it is enabled.
    *
    * @param payLg the pay lg
    */
    public void cacheResult(gov.va.caret.model.PayLg payLg);

    /**
    * Caches the pay lgs in the entity cache if it is enabled.
    *
    * @param payLgs the pay lgs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.PayLg> payLgs);

    /**
    * Creates a new pay lg with the primary key. Does not add the pay lg to the database.
    *
    * @param paymentLogId the primary key for the new pay lg
    * @return the new pay lg
    */
    public gov.va.caret.model.PayLg create(long paymentLogId);

    /**
    * Removes the pay lg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param paymentLogId the primary key of the pay lg
    * @return the pay lg that was removed
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg remove(long paymentLogId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    public gov.va.caret.model.PayLg updateImpl(gov.va.caret.model.PayLg payLg)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the pay lg with the primary key or throws a {@link gov.va.caret.NoSuchPayLgException} if it could not be found.
    *
    * @param paymentLogId the primary key of the pay lg
    * @return the pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg findByPrimaryKey(long paymentLogId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException;

    /**
    * Returns the pay lg with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param paymentLogId the primary key of the pay lg
    * @return the pay lg, or <code>null</code> if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.PayLg fetchByPrimaryKey(long paymentLogId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the pay lgs.
    *
    * @return the pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the pay lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @return the range of pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the pay lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of pay lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.PayLg> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the pay lgs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of pay lgs.
    *
    * @return the number of pay lgs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
