/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.PMMessage;

/**
 * The persistence interface for the p m message service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PMMessagePersistenceImpl
 * @see PMMessageUtil
 * @generated
 */
public interface PMMessagePersistence extends BasePersistence<PMMessage> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link PMMessageUtil} to access the p m message persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	* Returns all the p m messages where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findByOwnerId(
		long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the p m messages where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of p m messages
	* @param end the upper bound of the range of p m messages (not inclusive)
	* @return the range of matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findByOwnerId(
		long ownerId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the p m messages where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of p m messages
	* @param end the upper bound of the range of p m messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findByOwnerId(
		long ownerId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first p m message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage findByOwnerId_First(long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Returns the first p m message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m message, or <code>null</code> if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage fetchByOwnerId_First(long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last p m message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage findByOwnerId_Last(long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Returns the last p m message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m message, or <code>null</code> if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage fetchByOwnerId_Last(long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the p m messages before and after the current p m message in the ordered set where ownerId = &#63;.
	*
	* @param messageId the primary key of the current p m message
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a p m message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage[] findByOwnerId_PrevAndNext(
		long messageId, long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Removes all the p m messages where ownerId = &#63; from the database.
	*
	* @param ownerId the owner ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByOwnerId(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of p m messages where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the number of matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public int countByOwnerId(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the p m messages where parentMessageId = &#63;.
	*
	* @param parentMessageId the parent message ID
	* @return the matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findByParentMessageId(
		long parentMessageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the p m messages where parentMessageId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param parentMessageId the parent message ID
	* @param start the lower bound of the range of p m messages
	* @param end the upper bound of the range of p m messages (not inclusive)
	* @return the range of matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findByParentMessageId(
		long parentMessageId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the p m messages where parentMessageId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param parentMessageId the parent message ID
	* @param start the lower bound of the range of p m messages
	* @param end the upper bound of the range of p m messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findByParentMessageId(
		long parentMessageId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first p m message in the ordered set where parentMessageId = &#63;.
	*
	* @param parentMessageId the parent message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage findByParentMessageId_First(
		long parentMessageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Returns the first p m message in the ordered set where parentMessageId = &#63;.
	*
	* @param parentMessageId the parent message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m message, or <code>null</code> if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage fetchByParentMessageId_First(
		long parentMessageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last p m message in the ordered set where parentMessageId = &#63;.
	*
	* @param parentMessageId the parent message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage findByParentMessageId_Last(
		long parentMessageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Returns the last p m message in the ordered set where parentMessageId = &#63;.
	*
	* @param parentMessageId the parent message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m message, or <code>null</code> if a matching p m message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage fetchByParentMessageId_Last(
		long parentMessageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the p m messages before and after the current p m message in the ordered set where parentMessageId = &#63;.
	*
	* @param messageId the primary key of the current p m message
	* @param parentMessageId the parent message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a p m message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage[] findByParentMessageId_PrevAndNext(
		long messageId, long parentMessageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Removes all the p m messages where parentMessageId = &#63; from the database.
	*
	* @param parentMessageId the parent message ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByParentMessageId(long parentMessageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of p m messages where parentMessageId = &#63;.
	*
	* @param parentMessageId the parent message ID
	* @return the number of matching p m messages
	* @throws SystemException if a system exception occurred
	*/
	public int countByParentMessageId(long parentMessageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Caches the p m message in the entity cache if it is enabled.
	*
	* @param pmMessage the p m message
	*/
	public void cacheResult(gov.va.caret.model.PMMessage pmMessage);

	/**
	* Caches the p m messages in the entity cache if it is enabled.
	*
	* @param pmMessages the p m messages
	*/
	public void cacheResult(
		java.util.List<gov.va.caret.model.PMMessage> pmMessages);

	/**
	* Creates a new p m message with the primary key. Does not add the p m message to the database.
	*
	* @param messageId the primary key for the new p m message
	* @return the new p m message
	*/
	public gov.va.caret.model.PMMessage create(long messageId);

	/**
	* Removes the p m message with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param messageId the primary key of the p m message
	* @return the p m message that was removed
	* @throws gov.va.caret.NoSuchPMMessageException if a p m message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage remove(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	public gov.va.caret.model.PMMessage updateImpl(
		gov.va.caret.model.PMMessage pmMessage)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the p m message with the primary key or throws a {@link gov.va.caret.NoSuchPMMessageException} if it could not be found.
	*
	* @param messageId the primary key of the p m message
	* @return the p m message
	* @throws gov.va.caret.NoSuchPMMessageException if a p m message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage findByPrimaryKey(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMMessageException;

	/**
	* Returns the p m message with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param messageId the primary key of the p m message
	* @return the p m message, or <code>null</code> if a p m message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMMessage fetchByPrimaryKey(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the p m messages.
	*
	* @return the p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the p m messages.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of p m messages
	* @param end the upper bound of the range of p m messages (not inclusive)
	* @return the range of p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findAll(int start,
		int end) throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the p m messages.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of p m messages
	* @param end the upper bound of the range of p m messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of p m messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMMessage> findAll(int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the p m messages from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of p m messages.
	*
	* @return the number of p m messages
	* @throws SystemException if a system exception occurred
	*/
	public int countAll()
		throws com.liferay.portal.kernel.exception.SystemException;
}