package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Notif;

/**
 * The persistence interface for the notif service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see NotifPersistenceImpl
 * @see NotifUtil
 * @generated
 */
public interface NotifPersistence extends BasePersistence<Notif> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link NotifUtil} to access the notif persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Caches the notif in the entity cache if it is enabled.
    *
    * @param notif the notif
    */
    public void cacheResult(gov.va.caret.model.Notif notif);

    /**
    * Caches the notifs in the entity cache if it is enabled.
    *
    * @param notifs the notifs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Notif> notifs);

    /**
    * Creates a new notif with the primary key. Does not add the notif to the database.
    *
    * @param notifId the primary key for the new notif
    * @return the new notif
    */
    public gov.va.caret.model.Notif create(long notifId);

    /**
    * Removes the notif with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param notifId the primary key of the notif
    * @return the notif that was removed
    * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Notif remove(long notifId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNotifException;

    public gov.va.caret.model.Notif updateImpl(gov.va.caret.model.Notif notif)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the notif with the primary key or throws a {@link gov.va.caret.NoSuchNotifException} if it could not be found.
    *
    * @param notifId the primary key of the notif
    * @return the notif
    * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Notif findByPrimaryKey(long notifId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNotifException;

    /**
    * Returns the notif with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param notifId the primary key of the notif
    * @return the notif, or <code>null</code> if a notif with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Notif fetchByPrimaryKey(long notifId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the notifs.
    *
    * @return the notifs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Notif> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the notifs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NotifModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of notifs
    * @param end the upper bound of the range of notifs (not inclusive)
    * @return the range of notifs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Notif> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the notifs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NotifModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of notifs
    * @param end the upper bound of the range of notifs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of notifs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Notif> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the notifs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of notifs.
    *
    * @return the number of notifs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
