package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Call;

/**
 * The persistence interface for the call service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CallPersistenceImpl
 * @see CallUtil
 * @generated
 */
public interface CallPersistence extends BasePersistence<Call> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link CallUtil} to access the call persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the calls where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByCreateGroupId(
        long createGroupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the calls where createGroupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param createGroupId the create group ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByCreateGroupId(
        long createGroupId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the calls where createGroupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param createGroupId the create group ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByCreateGroupId(
        long createGroupId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByCreateGroupId_First(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the first call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByCreateGroupId_First(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByCreateGroupId_Last(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the last call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByCreateGroupId_Last(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the calls before and after the current call in the ordered set where createGroupId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call[] findByCreateGroupId_PrevAndNext(
        long callId, long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Removes all the calls where createGroupId = &#63; from the database.
    *
    * @param createGroupId the create group ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByCreateGroupId(long createGroupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of calls where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public int countByCreateGroupId(long createGroupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the calls where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByCallerPersnId(
        long callerPersnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the calls where callerPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callerPersnId the caller persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByCallerPersnId(
        long callerPersnId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the calls where callerPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callerPersnId the caller persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByCallerPersnId(
        long callerPersnId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByCallerPersnId_First(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the first call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByCallerPersnId_First(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByCallerPersnId_Last(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the last call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByCallerPersnId_Last(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the calls before and after the current call in the ordered set where callerPersnId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call[] findByCallerPersnId_PrevAndNext(
        long callId, long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Removes all the calls where callerPersnId = &#63; from the database.
    *
    * @param callerPersnId the caller persn ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByCallerPersnId(long callerPersnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of calls where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public int countByCallerPersnId(long callerPersnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the calls where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByVeteranPersnId(
        long veteranPersnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the calls where veteranPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param veteranPersnId the veteran persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByVeteranPersnId(
        long veteranPersnId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the calls where veteranPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param veteranPersnId the veteran persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByVeteranPersnId(
        long veteranPersnId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByVeteranPersnId_First(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the first call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByVeteranPersnId_First(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByVeteranPersnId_Last(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the last call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByVeteranPersnId_Last(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the calls before and after the current call in the ordered set where veteranPersnId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call[] findByVeteranPersnId_PrevAndNext(
        long callId, long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Removes all the calls where veteranPersnId = &#63; from the database.
    *
    * @param veteranPersnId the veteran persn ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByVeteranPersnId(long veteranPersnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of calls where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public int countByVeteranPersnId(long veteranPersnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the calls where userId = &#63;.
    *
    * @param userId the user ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the calls where userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param userId the user ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByUserId(long userId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the calls where userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param userId the user ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findByUserId(long userId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByUserId_First(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the first call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByUserId_First(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByUserId_Last(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the last call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByUserId_Last(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the calls before and after the current call in the ordered set where userId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call[] findByUserId_PrevAndNext(long callId,
        long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Removes all the calls where userId = &#63; from the database.
    *
    * @param userId the user ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of calls where userId = &#63;.
    *
    * @param userId the user ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public int countByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the call in the entity cache if it is enabled.
    *
    * @param call the call
    */
    public void cacheResult(gov.va.caret.model.Call call);

    /**
    * Caches the calls in the entity cache if it is enabled.
    *
    * @param calls the calls
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Call> calls);

    /**
    * Creates a new call with the primary key. Does not add the call to the database.
    *
    * @param callId the primary key for the new call
    * @return the new call
    */
    public gov.va.caret.model.Call create(long callId);

    /**
    * Removes the call with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param callId the primary key of the call
    * @return the call that was removed
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call remove(long callId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    public gov.va.caret.model.Call updateImpl(gov.va.caret.model.Call call)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the call with the primary key or throws a {@link gov.va.caret.NoSuchCallException} if it could not be found.
    *
    * @param callId the primary key of the call
    * @return the call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call findByPrimaryKey(long callId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException;

    /**
    * Returns the call with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param callId the primary key of the call
    * @return the call, or <code>null</code> if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Call fetchByPrimaryKey(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the calls.
    *
    * @return the calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the calls.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the calls.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of calls
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Call> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the calls from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of calls.
    *
    * @return the number of calls
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
