package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BlsAe;

/**
 * The persistence interface for the bls ae service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BlsAePersistenceImpl
 * @see BlsAeUtil
 * @generated
 */
public interface BlsAePersistence extends BasePersistence<BlsAe> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link BlsAeUtil} to access the bls ae persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns the bls ae where areaNumber = &#63; or throws a {@link gov.va.caret.NoSuchBlsAeException} if it could not be found.
    *
    * @param areaNumber the area number
    * @return the matching bls ae
    * @throws gov.va.caret.NoSuchBlsAeException if a matching bls ae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe findByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException;

    /**
    * Returns the bls ae where areaNumber = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param areaNumber the area number
    * @return the matching bls ae, or <code>null</code> if a matching bls ae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe fetchByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bls ae where areaNumber = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param areaNumber the area number
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bls ae, or <code>null</code> if a matching bls ae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe fetchByNumber(int areaNumber,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the bls ae where areaNumber = &#63; from the database.
    *
    * @param areaNumber the area number
    * @return the bls ae that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe removeByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException;

    /**
    * Returns the number of bls aes where areaNumber = &#63;.
    *
    * @param areaNumber the area number
    * @return the number of matching bls aes
    * @throws SystemException if a system exception occurred
    */
    public int countByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the bls ae in the entity cache if it is enabled.
    *
    * @param blsAe the bls ae
    */
    public void cacheResult(gov.va.caret.model.BlsAe blsAe);

    /**
    * Caches the bls aes in the entity cache if it is enabled.
    *
    * @param blsAes the bls aes
    */
    public void cacheResult(java.util.List<gov.va.caret.model.BlsAe> blsAes);

    /**
    * Creates a new bls ae with the primary key. Does not add the bls ae to the database.
    *
    * @param blsAeId the primary key for the new bls ae
    * @return the new bls ae
    */
    public gov.va.caret.model.BlsAe create(long blsAeId);

    /**
    * Removes the bls ae with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param blsAeId the primary key of the bls ae
    * @return the bls ae that was removed
    * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe remove(long blsAeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException;

    public gov.va.caret.model.BlsAe updateImpl(gov.va.caret.model.BlsAe blsAe)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bls ae with the primary key or throws a {@link gov.va.caret.NoSuchBlsAeException} if it could not be found.
    *
    * @param blsAeId the primary key of the bls ae
    * @return the bls ae
    * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe findByPrimaryKey(long blsAeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException;

    /**
    * Returns the bls ae with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param blsAeId the primary key of the bls ae
    * @return the bls ae, or <code>null</code> if a bls ae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsAe fetchByPrimaryKey(long blsAeId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bls aes.
    *
    * @return the bls aes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsAe> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bls aes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsAeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls aes
    * @param end the upper bound of the range of bls aes (not inclusive)
    * @return the range of bls aes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsAe> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bls aes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsAeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls aes
    * @param end the upper bound of the range of bls aes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bls aes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsAe> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the bls aes from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bls aes.
    *
    * @return the number of bls aes
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
