package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BgNum;

import java.util.List;

/**
 * The persistence utility for the bg num service. This utility wraps {@link BgNumPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgNumPersistence
 * @see BgNumPersistenceImpl
 * @generated
 */
public class BgNumUtil {
    private static BgNumPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(BgNum bgNum) {
        getPersistence().clearCache(bgNum);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<BgNum> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<BgNum> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<BgNum> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static BgNum update(BgNum bgNum) throws SystemException {
        return getPersistence().update(bgNum);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static BgNum update(BgNum bgNum, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(bgNum, serviceContext);
    }

    /**
    * Returns all the bg nums where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgNum> findByBoxGroupNumberAssociations(
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxGroupNumberAssociations(ownerId);
    }

    /**
    * Returns a range of all the bg nums where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @return the range of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgNum> findByBoxGroupNumberAssociations(
        long ownerId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxGroupNumberAssociations(ownerId, start, end);
    }

    /**
    * Returns an ordered range of all the bg nums where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgNum> findByBoxGroupNumberAssociations(
        long ownerId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxGroupNumberAssociations(ownerId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg num
    * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum findByBoxGroupNumberAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence()
                   .findByBoxGroupNumberAssociations_First(ownerId,
            orderByComparator);
    }

    /**
    * Returns the first bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum fetchByBoxGroupNumberAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroupNumberAssociations_First(ownerId,
            orderByComparator);
    }

    /**
    * Returns the last bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg num
    * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum findByBoxGroupNumberAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence()
                   .findByBoxGroupNumberAssociations_Last(ownerId,
            orderByComparator);
    }

    /**
    * Returns the last bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum fetchByBoxGroupNumberAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroupNumberAssociations_Last(ownerId,
            orderByComparator);
    }

    /**
    * Returns the bg nums before and after the current bg num in the ordered set where ownerId = &#63;.
    *
    * @param bgNumId the primary key of the current bg num
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg num
    * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum[] findByBoxGroupNumberAssociations_PrevAndNext(
        long bgNumId, long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence()
                   .findByBoxGroupNumberAssociations_PrevAndNext(bgNumId,
            ownerId, orderByComparator);
    }

    /**
    * Removes all the bg nums where ownerId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByBoxGroupNumberAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByBoxGroupNumberAssociations(ownerId);
    }

    /**
    * Returns the number of bg nums where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the number of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public static int countByBoxGroupNumberAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBoxGroupNumberAssociations(ownerId);
    }

    /**
    * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgNumException} if it could not be found.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg num
    * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum findByBgNumInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence().findByBgNumInst(ownerId, boxGpId);
    }

    /**
    * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum fetchByBgNumInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByBgNumInst(ownerId, boxGpId);
    }

    /**
    * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum fetchByBgNumInst(long ownerId,
        long boxGpId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBgNumInst(ownerId, boxGpId, retrieveFromCache);
    }

    /**
    * Removes the bg num where ownerId = &#63; and boxGpId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the bg num that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum removeByBgNumInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence().removeByBgNumInst(ownerId, boxGpId);
    }

    /**
    * Returns the number of bg nums where ownerId = &#63; and boxGpId = &#63;.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the number of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public static int countByBgNumInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBgNumInst(ownerId, boxGpId);
    }

    /**
    * Caches the bg num in the entity cache if it is enabled.
    *
    * @param bgNum the bg num
    */
    public static void cacheResult(gov.va.caret.model.BgNum bgNum) {
        getPersistence().cacheResult(bgNum);
    }

    /**
    * Caches the bg nums in the entity cache if it is enabled.
    *
    * @param bgNums the bg nums
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.BgNum> bgNums) {
        getPersistence().cacheResult(bgNums);
    }

    /**
    * Creates a new bg num with the primary key. Does not add the bg num to the database.
    *
    * @param bgNumId the primary key for the new bg num
    * @return the new bg num
    */
    public static gov.va.caret.model.BgNum create(long bgNumId) {
        return getPersistence().create(bgNumId);
    }

    /**
    * Removes the bg num with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num that was removed
    * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum remove(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence().remove(bgNumId);
    }

    public static gov.va.caret.model.BgNum updateImpl(
        gov.va.caret.model.BgNum bgNum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(bgNum);
    }

    /**
    * Returns the bg num with the primary key or throws a {@link gov.va.caret.NoSuchBgNumException} if it could not be found.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num
    * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum findByPrimaryKey(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException {
        return getPersistence().findByPrimaryKey(bgNumId);
    }

    /**
    * Returns the bg num with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num, or <code>null</code> if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgNum fetchByPrimaryKey(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(bgNumId);
    }

    /**
    * Returns all the bg nums.
    *
    * @return the bg nums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgNum> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the bg nums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @return the range of bg nums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgNum> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the bg nums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bg nums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgNum> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the bg nums from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of bg nums.
    *
    * @return the number of bg nums
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static BgNumPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (BgNumPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    BgNumPersistence.class.getName());

            ReferenceRegistry.registerReference(BgNumUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(BgNumPersistence persistence) {
    }
}
