package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BgAsn;

import java.util.List;

/**
 * The persistence utility for the bg asn service. This utility wraps {@link BgAsnPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgAsnPersistence
 * @see BgAsnPersistenceImpl
 * @generated
 */
public class BgAsnUtil {
    private static BgAsnPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(BgAsn bgAsn) {
        getPersistence().clearCache(bgAsn);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<BgAsn> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<BgAsn> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<BgAsn> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static BgAsn update(BgAsn bgAsn) throws SystemException {
        return getPersistence().update(bgAsn);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static BgAsn update(BgAsn bgAsn, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(bgAsn, serviceContext);
    }

    /**
    * Returns all the bg asns where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findByBoxGroupAssociations(
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxGroupAssociations(ownerId);
    }

    /**
    * Returns a range of all the bg asns where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findByBoxGroupAssociations(
        long ownerId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxGroupAssociations(ownerId, start, end);
    }

    /**
    * Returns an ordered range of all the bg asns where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findByBoxGroupAssociations(
        long ownerId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxGroupAssociations(ownerId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn findByBoxGroupAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence()
                   .findByBoxGroupAssociations_First(ownerId, orderByComparator);
    }

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchByBoxGroupAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroupAssociations_First(ownerId, orderByComparator);
    }

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn findByBoxGroupAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence()
                   .findByBoxGroupAssociations_Last(ownerId, orderByComparator);
    }

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchByBoxGroupAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroupAssociations_Last(ownerId, orderByComparator);
    }

    /**
    * Returns the bg asns before and after the current bg asn in the ordered set where ownerId = &#63;.
    *
    * @param bgAsnId the primary key of the current bg asn
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn[] findByBoxGroupAssociations_PrevAndNext(
        long bgAsnId, long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence()
                   .findByBoxGroupAssociations_PrevAndNext(bgAsnId, ownerId,
            orderByComparator);
    }

    /**
    * Removes all the bg asns where ownerId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByBoxGroupAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByBoxGroupAssociations(ownerId);
    }

    /**
    * Returns the number of bg asns where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the number of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static int countByBoxGroupAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBoxGroupAssociations(ownerId);
    }

    /**
    * Returns all the bg asns where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @return the matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findBySelectedBoxGroupAssociations(
        long ownerId, boolean selected)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findBySelectedBoxGroupAssociations(ownerId, selected);
    }

    /**
    * Returns a range of all the bg asns where ownerId = &#63; and selected = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findBySelectedBoxGroupAssociations(
        long ownerId, boolean selected, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findBySelectedBoxGroupAssociations(ownerId, selected,
            start, end);
    }

    /**
    * Returns an ordered range of all the bg asns where ownerId = &#63; and selected = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findBySelectedBoxGroupAssociations(
        long ownerId, boolean selected, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findBySelectedBoxGroupAssociations(ownerId, selected,
            start, end, orderByComparator);
    }

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn findBySelectedBoxGroupAssociations_First(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence()
                   .findBySelectedBoxGroupAssociations_First(ownerId, selected,
            orderByComparator);
    }

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchBySelectedBoxGroupAssociations_First(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchBySelectedBoxGroupAssociations_First(ownerId,
            selected, orderByComparator);
    }

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn findBySelectedBoxGroupAssociations_Last(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence()
                   .findBySelectedBoxGroupAssociations_Last(ownerId, selected,
            orderByComparator);
    }

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchBySelectedBoxGroupAssociations_Last(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchBySelectedBoxGroupAssociations_Last(ownerId, selected,
            orderByComparator);
    }

    /**
    * Returns the bg asns before and after the current bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param bgAsnId the primary key of the current bg asn
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn[] findBySelectedBoxGroupAssociations_PrevAndNext(
        long bgAsnId, long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence()
                   .findBySelectedBoxGroupAssociations_PrevAndNext(bgAsnId,
            ownerId, selected, orderByComparator);
    }

    /**
    * Removes all the bg asns where ownerId = &#63; and selected = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @throws SystemException if a system exception occurred
    */
    public static void removeBySelectedBoxGroupAssociations(long ownerId,
        boolean selected)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeBySelectedBoxGroupAssociations(ownerId, selected);
    }

    /**
    * Returns the number of bg asns where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @return the number of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static int countBySelectedBoxGroupAssociations(long ownerId,
        boolean selected)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .countBySelectedBoxGroupAssociations(ownerId, selected);
    }

    /**
    * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgAsnException} if it could not be found.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn findByBgAsnInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence().findByBgAsnInst(ownerId, boxGpId);
    }

    /**
    * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchByBgAsnInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByBgAsnInst(ownerId, boxGpId);
    }

    /**
    * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchByBgAsnInst(long ownerId,
        long boxGpId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBgAsnInst(ownerId, boxGpId, retrieveFromCache);
    }

    /**
    * Removes the bg asn where ownerId = &#63; and boxGpId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the bg asn that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn removeByBgAsnInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence().removeByBgAsnInst(ownerId, boxGpId);
    }

    /**
    * Returns the number of bg asns where ownerId = &#63; and boxGpId = &#63;.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the number of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public static int countByBgAsnInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBgAsnInst(ownerId, boxGpId);
    }

    /**
    * Caches the bg asn in the entity cache if it is enabled.
    *
    * @param bgAsn the bg asn
    */
    public static void cacheResult(gov.va.caret.model.BgAsn bgAsn) {
        getPersistence().cacheResult(bgAsn);
    }

    /**
    * Caches the bg asns in the entity cache if it is enabled.
    *
    * @param bgAsns the bg asns
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.BgAsn> bgAsns) {
        getPersistence().cacheResult(bgAsns);
    }

    /**
    * Creates a new bg asn with the primary key. Does not add the bg asn to the database.
    *
    * @param bgAsnId the primary key for the new bg asn
    * @return the new bg asn
    */
    public static gov.va.caret.model.BgAsn create(long bgAsnId) {
        return getPersistence().create(bgAsnId);
    }

    /**
    * Removes the bg asn with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn that was removed
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn remove(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence().remove(bgAsnId);
    }

    public static gov.va.caret.model.BgAsn updateImpl(
        gov.va.caret.model.BgAsn bgAsn)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(bgAsn);
    }

    /**
    * Returns the bg asn with the primary key or throws a {@link gov.va.caret.NoSuchBgAsnException} if it could not be found.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn findByPrimaryKey(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException {
        return getPersistence().findByPrimaryKey(bgAsnId);
    }

    /**
    * Returns the bg asn with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn, or <code>null</code> if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgAsn fetchByPrimaryKey(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(bgAsnId);
    }

    /**
    * Returns all the bg asns.
    *
    * @return the bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the bg asns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the bg asns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bg asns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgAsn> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the bg asns from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of bg asns.
    *
    * @return the number of bg asns
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static BgAsnPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (BgAsnPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    BgAsnPersistence.class.getName());

            ReferenceRegistry.registerReference(BgAsnUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(BgAsnPersistence persistence) {
    }
}
