package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Assmt;

/**
 * The persistence interface for the assmt service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see AssmtPersistenceImpl
 * @see AssmtUtil
 * @generated
 */
public interface AssmtPersistence extends BasePersistence<Assmt> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link AssmtUtil} to access the assmt persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the assmts where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @return the matching assmts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Assmt> findByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the assmts where vcgId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgId the vcg ID
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @return the range of matching assmts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Assmt> findByVcgId(long vcgId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the assmts where vcgId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgId the vcg ID
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching assmts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Assmt> findByVcgId(long vcgId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching assmt
    * @throws gov.va.caret.NoSuchAssmtException if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt findByVcgId_First(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException;

    /**
    * Returns the first assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching assmt, or <code>null</code> if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt fetchByVcgId_First(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching assmt
    * @throws gov.va.caret.NoSuchAssmtException if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt findByVcgId_Last(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException;

    /**
    * Returns the last assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching assmt, or <code>null</code> if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt fetchByVcgId_Last(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the assmts before and after the current assmt in the ordered set where vcgId = &#63;.
    *
    * @param assmtId the primary key of the current assmt
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next assmt
    * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt[] findByVcgId_PrevAndNext(long assmtId,
        long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException;

    /**
    * Removes all the assmts where vcgId = &#63; from the database.
    *
    * @param vcgId the vcg ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of assmts where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @return the number of matching assmts
    * @throws SystemException if a system exception occurred
    */
    public int countByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the assmt in the entity cache if it is enabled.
    *
    * @param assmt the assmt
    */
    public void cacheResult(gov.va.caret.model.Assmt assmt);

    /**
    * Caches the assmts in the entity cache if it is enabled.
    *
    * @param assmts the assmts
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Assmt> assmts);

    /**
    * Creates a new assmt with the primary key. Does not add the assmt to the database.
    *
    * @param assmtId the primary key for the new assmt
    * @return the new assmt
    */
    public gov.va.caret.model.Assmt create(long assmtId);

    /**
    * Removes the assmt with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt that was removed
    * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt remove(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException;

    public gov.va.caret.model.Assmt updateImpl(gov.va.caret.model.Assmt assmt)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the assmt with the primary key or throws a {@link gov.va.caret.NoSuchAssmtException} if it could not be found.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt
    * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt findByPrimaryKey(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException;

    /**
    * Returns the assmt with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt, or <code>null</code> if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Assmt fetchByPrimaryKey(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the assmts.
    *
    * @return the assmts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Assmt> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the assmts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @return the range of assmts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Assmt> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the assmts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of assmts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Assmt> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the assmts from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of assmts.
    *
    * @return the number of assmts
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
