package gov.va.caret.service;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.InvokableLocalService;

/**
 * Provides the local service utility for EEMilitaryRecord. This utility wraps
 * {@link gov.va.caret.service.impl.EEMilitaryRecordLocalServiceImpl} and is the
 * primary access point for service operations in application layer code running
 * on the local server. Methods of this service will not have security checks
 * based on the propagated JAAS credentials because this service can only be
 * accessed from within the same VM.
 *
 * @author caret
 * @see EEMilitaryRecordLocalService
 * @see gov.va.caret.service.base.EEMilitaryRecordLocalServiceBaseImpl
 * @see gov.va.caret.service.impl.EEMilitaryRecordLocalServiceImpl
 * @generated
 */
public class EEMilitaryRecordLocalServiceUtil {
    private static EEMilitaryRecordLocalService _service;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Add custom service methods to {@link gov.va.caret.service.impl.EEMilitaryRecordLocalServiceImpl} and rerun ServiceBuilder to regenerate this class.
     */

    /**
    * Adds the e e military record to the database. Also notifies the appropriate model listeners.
    *
    * @param eeMilitaryRecord the e e military record
    * @return the e e military record that was added
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.EEMilitaryRecord addEEMilitaryRecord(
        gov.va.caret.model.EEMilitaryRecord eeMilitaryRecord)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().addEEMilitaryRecord(eeMilitaryRecord);
    }

    /**
    * Creates a new e e military record with the primary key. Does not add the e e military record to the database.
    *
    * @param eeMilRecordId the primary key for the new e e military record
    * @return the new e e military record
    */
    public static gov.va.caret.model.EEMilitaryRecord createEEMilitaryRecord(
        long eeMilRecordId) {
        return getService().createEEMilitaryRecord(eeMilRecordId);
    }

    /**
    * Deletes the e e military record with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param eeMilRecordId the primary key of the e e military record
    * @return the e e military record that was removed
    * @throws PortalException if a e e military record with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.EEMilitaryRecord deleteEEMilitaryRecord(
        long eeMilRecordId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return getService().deleteEEMilitaryRecord(eeMilRecordId);
    }

    /**
    * Deletes the e e military record from the database. Also notifies the appropriate model listeners.
    *
    * @param eeMilitaryRecord the e e military record
    * @return the e e military record that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.EEMilitaryRecord deleteEEMilitaryRecord(
        gov.va.caret.model.EEMilitaryRecord eeMilitaryRecord)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().deleteEEMilitaryRecord(eeMilitaryRecord);
    }

    public static com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return getService().dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @SuppressWarnings("rawtypes")
    public static java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @SuppressWarnings("rawtypes")
    public static java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @SuppressWarnings("rawtypes")
    public static java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService()
                   .dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    public static long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    public static long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQueryCount(dynamicQuery, projection);
    }

    public static gov.va.caret.model.EEMilitaryRecord fetchEEMilitaryRecord(
        long eeMilRecordId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().fetchEEMilitaryRecord(eeMilRecordId);
    }

    /**
    * Returns the e e military record with the primary key.
    *
    * @param eeMilRecordId the primary key of the e e military record
    * @return the e e military record
    * @throws PortalException if a e e military record with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.EEMilitaryRecord getEEMilitaryRecord(
        long eeMilRecordId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return getService().getEEMilitaryRecord(eeMilRecordId);
    }

    public static com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return getService().getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the e e military records.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of e e military records
    * @param end the upper bound of the range of e e military records (not inclusive)
    * @return the range of e e military records
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.EEMilitaryRecord> getEEMilitaryRecords(
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().getEEMilitaryRecords(start, end);
    }

    /**
    * Returns the number of e e military records.
    *
    * @return the number of e e military records
    * @throws SystemException if a system exception occurred
    */
    public static int getEEMilitaryRecordsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().getEEMilitaryRecordsCount();
    }

    /**
    * Updates the e e military record in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param eeMilitaryRecord the e e military record
    * @return the e e military record that was updated
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.EEMilitaryRecord updateEEMilitaryRecord(
        gov.va.caret.model.EEMilitaryRecord eeMilitaryRecord)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().updateEEMilitaryRecord(eeMilitaryRecord);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    public static java.lang.String getBeanIdentifier() {
        return getService().getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    public static void setBeanIdentifier(java.lang.String beanIdentifier) {
        getService().setBeanIdentifier(beanIdentifier);
    }

    public static java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return getService().invokeMethod(name, parameterTypes, arguments);
    }

    /**
    * Returns all the e e military records where eeLgId = &#63;.
    *
    * @param eeLgId the ee lg ID
    * @return the matching e e military records
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.EEMilitaryRecord> findByeeLgId(
        long eeLgId) throws com.liferay.portal.kernel.exception.SystemException {
        return getService().findByeeLgId(eeLgId);
    }

    public static void clearService() {
        _service = null;
    }

    public static EEMilitaryRecordLocalService getService() {
        if (_service == null) {
            InvokableLocalService invokableLocalService = (InvokableLocalService) PortletBeanLocatorUtil.locate(ClpSerializer.getServletContextName(),
                    EEMilitaryRecordLocalService.class.getName());

            if (invokableLocalService instanceof EEMilitaryRecordLocalService) {
                _service = (EEMilitaryRecordLocalService) invokableLocalService;
            } else {
                _service = new EEMilitaryRecordLocalServiceClp(invokableLocalService);
            }

            ReferenceRegistry.registerReference(EEMilitaryRecordLocalServiceUtil.class,
                "_service");
        }

        return _service;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setService(EEMilitaryRecordLocalService service) {
    }
}
