package gov.va.caret.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.service.BaseLocalService;
import com.liferay.portal.service.InvokableLocalService;

/**
 * Provides the local service interface for Caret. Methods of this
 * service will not have security checks based on the propagated JAAS
 * credentials because this service can only be accessed from within the same
 * VM.
 *
 * @author caret
 * @see CaretLocalServiceUtil
 * @see gov.va.caret.service.base.CaretLocalServiceBaseImpl
 * @see gov.va.caret.service.impl.CaretLocalServiceImpl
 * @generated
 */
@Transactional(isolation = Isolation.PORTAL, rollbackFor =  {
    PortalException.class, SystemException.class}
)
public interface CaretLocalService extends BaseLocalService,
    InvokableLocalService {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link CaretLocalServiceUtil} to access the caret local service. Add custom service methods to {@link gov.va.caret.service.impl.CaretLocalServiceImpl} and rerun ServiceBuilder to automatically copy the method declarations to this interface.
     */

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    public java.lang.String getBeanIdentifier();

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    public void setBeanIdentifier(java.lang.String beanIdentifier);

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public int getReportCount(java.lang.String name, java.lang.Object entries)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getReport(
        java.lang.String name, java.lang.Object entries)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getReport(
        java.lang.String name, java.lang.Object entries, int start, int end)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getReport(
        java.lang.String name, java.lang.Object entries,
        java.lang.String column, boolean desc, int start, int end)
        throws gov.va.caret.ApplicationWorkFlowException;

    public com.liferay.portal.model.BaseModel<?> save(
        com.liferay.portal.model.BaseModel<?> model)
        throws gov.va.caret.ApplicationWorkFlowException;

    public gov.va.caret.model.Note addNote(gov.va.caret.model.Note note)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public gov.va.caret.model.Facil getFacilityByNumber(
        java.lang.String facilityNumber)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.CalEt> getCallEvents(long callId)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.Assmt> getAssessments(long vcgId)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public gov.va.caret.model.AudLg getAudLg(long classId, long classPk,
        java.lang.String attribute)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.Docum> getByClass(
        long primaryKey, long classId, java.lang.String type)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.Docum> getByPrimaryKey(
        long primaryKey) throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public gov.va.caret.model.Persn getPerson(long persnId)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public gov.va.caret.model.VcgAn getPrimaryApp(long veteranId)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.BoxGp> getBoxGroups(
        java.lang.String name) throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.BoxGp> getBoxGroups(
        java.lang.String boxGroup, java.lang.String boxSubGroup)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.BgAsn> getBoxGroupAssociations(
        long ownerId) throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public java.util.List<gov.va.caret.model.BgAsn> getBoxGroupAssociations(
        long ownerId, boolean enabled)
        throws gov.va.caret.ApplicationWorkFlowException;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public gov.va.caret.model.BgAsn getBoxGroupAssociation(long ownerId,
        long boxGpId) throws gov.va.caret.ApplicationWorkFlowException;
}
