package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link ZipFy}.
 * </p>
 *
 * @author caret
 * @see ZipFy
 * @generated
 */
public class ZipFyWrapper implements ZipFy, ModelWrapper<ZipFy> {
    private ZipFy _zipFy;

    public ZipFyWrapper(ZipFy zipFy) {
        _zipFy = zipFy;
    }

    @Override
    public Class<?> getModelClass() {
        return ZipFy.class;
    }

    @Override
    public String getModelClassName() {
        return ZipFy.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("zipFyId", getZipFyId());
        attributes.put("facilId", getFacilId());
        attributes.put("facilZip", getFacilZip());
        attributes.put("distance", getDistance());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long zipFyId = (Long) attributes.get("zipFyId");

        if (zipFyId != null) {
            setZipFyId(zipFyId);
        }

        Long facilId = (Long) attributes.get("facilId");

        if (facilId != null) {
            setFacilId(facilId);
        }

        String facilZip = (String) attributes.get("facilZip");

        if (facilZip != null) {
            setFacilZip(facilZip);
        }

        Double distance = (Double) attributes.get("distance");

        if (distance != null) {
            setDistance(distance);
        }
    }

    /**
    * Returns the primary key of this zip fy.
    *
    * @return the primary key of this zip fy
    */
    @Override
    public long getPrimaryKey() {
        return _zipFy.getPrimaryKey();
    }

    /**
    * Sets the primary key of this zip fy.
    *
    * @param primaryKey the primary key of this zip fy
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _zipFy.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the zip fy ID of this zip fy.
    *
    * @return the zip fy ID of this zip fy
    */
    @Override
    public long getZipFyId() {
        return _zipFy.getZipFyId();
    }

    /**
    * Sets the zip fy ID of this zip fy.
    *
    * @param zipFyId the zip fy ID of this zip fy
    */
    @Override
    public void setZipFyId(long zipFyId) {
        _zipFy.setZipFyId(zipFyId);
    }

    /**
    * Returns the facil ID of this zip fy.
    *
    * @return the facil ID of this zip fy
    */
    @Override
    public long getFacilId() {
        return _zipFy.getFacilId();
    }

    /**
    * Sets the facil ID of this zip fy.
    *
    * @param facilId the facil ID of this zip fy
    */
    @Override
    public void setFacilId(long facilId) {
        _zipFy.setFacilId(facilId);
    }

    /**
    * Returns the facil zip of this zip fy.
    *
    * @return the facil zip of this zip fy
    */
    @Override
    public java.lang.String getFacilZip() {
        return _zipFy.getFacilZip();
    }

    /**
    * Sets the facil zip of this zip fy.
    *
    * @param facilZip the facil zip of this zip fy
    */
    @Override
    public void setFacilZip(java.lang.String facilZip) {
        _zipFy.setFacilZip(facilZip);
    }

    /**
    * Returns the distance of this zip fy.
    *
    * @return the distance of this zip fy
    */
    @Override
    public double getDistance() {
        return _zipFy.getDistance();
    }

    /**
    * Sets the distance of this zip fy.
    *
    * @param distance the distance of this zip fy
    */
    @Override
    public void setDistance(double distance) {
        _zipFy.setDistance(distance);
    }

    @Override
    public boolean isNew() {
        return _zipFy.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _zipFy.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _zipFy.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _zipFy.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _zipFy.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _zipFy.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _zipFy.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _zipFy.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _zipFy.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _zipFy.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _zipFy.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new ZipFyWrapper((ZipFy) _zipFy.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.ZipFy zipFy) {
        return _zipFy.compareTo(zipFy);
    }

    @Override
    public int hashCode() {
        return _zipFy.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.ZipFy> toCacheModel() {
        return _zipFy.toCacheModel();
    }

    @Override
    public gov.va.caret.model.ZipFy toEscapedModel() {
        return new ZipFyWrapper(_zipFy.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.ZipFy toUnescapedModel() {
        return new ZipFyWrapper(_zipFy.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _zipFy.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _zipFy.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _zipFy.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof ZipFyWrapper)) {
            return false;
        }

        ZipFyWrapper zipFyWrapper = (ZipFyWrapper) obj;

        if (Validator.equals(_zipFy, zipFyWrapper._zipFy)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public ZipFy getWrappedZipFy() {
        return _zipFy;
    }

    @Override
    public ZipFy getWrappedModel() {
        return _zipFy;
    }

    @Override
    public void resetOriginalValues() {
        _zipFy.resetOriginalValues();
    }
}
