package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.WaivrLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class WaivrClp extends BaseModelImpl<Waivr> implements Waivr {
    private long _waivrId;
    private long _classPk;
    private String _adjudication;
    private String _reason;
    private String _note;
    private Date _creationDate;
    private Date _completionDate;
    private long _userId;
    private String _userUuid;
    private BaseModel<?> _waivrRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public WaivrClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Waivr.class;
    }

    @Override
    public String getModelClassName() {
        return Waivr.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _waivrId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setWaivrId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _waivrId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("waivrId", getWaivrId());
        attributes.put("classPk", getClassPk());
        attributes.put("adjudication", getAdjudication());
        attributes.put("reason", getReason());
        attributes.put("note", getNote());
        attributes.put("creationDate", getCreationDate());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long waivrId = (Long) attributes.get("waivrId");

        if (waivrId != null) {
            setWaivrId(waivrId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String adjudication = (String) attributes.get("adjudication");

        if (adjudication != null) {
            setAdjudication(adjudication);
        }

        String reason = (String) attributes.get("reason");

        if (reason != null) {
            setReason(reason);
        }

        String note = (String) attributes.get("note");

        if (note != null) {
            setNote(note);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    @Override
    public long getWaivrId() {
        return _waivrId;
    }

    @Override
    public void setWaivrId(long waivrId) {
        _waivrId = waivrId;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setWaivrId", long.class);

                method.invoke(_waivrRemoteModel, waivrId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _classPk = classPk;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setClassPk", long.class);

                method.invoke(_waivrRemoteModel, classPk);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAdjudication() {
        return _adjudication;
    }

    @Override
    public void setAdjudication(String adjudication) {
        _adjudication = adjudication;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setAdjudication", String.class);

                method.invoke(_waivrRemoteModel, adjudication);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getReason() {
        return _reason;
    }

    @Override
    public void setReason(String reason) {
        _reason = reason;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setReason", String.class);

                method.invoke(_waivrRemoteModel, reason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getNote() {
        return _note;
    }

    @Override
    public void setNote(String note) {
        _note = note;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setNote", String.class);

                method.invoke(_waivrRemoteModel, note);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_waivrRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCompletionDate() {
        return _completionDate;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setCompletionDate", Date.class);

                method.invoke(_waivrRemoteModel, completionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_waivrRemoteModel != null) {
            try {
                Class<?> clazz = _waivrRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_waivrRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public BaseModel<?> getWaivrRemoteModel() {
        return _waivrRemoteModel;
    }

    public void setWaivrRemoteModel(BaseModel<?> waivrRemoteModel) {
        _waivrRemoteModel = waivrRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _waivrRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_waivrRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            WaivrLocalServiceUtil.addWaivr(this);
        } else {
            WaivrLocalServiceUtil.updateWaivr(this);
        }
    }

    @Override
    public Waivr toEscapedModel() {
        return (Waivr) ProxyUtil.newProxyInstance(Waivr.class.getClassLoader(),
            new Class[] { Waivr.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        WaivrClp clone = new WaivrClp();

        clone.setWaivrId(getWaivrId());
        clone.setClassPk(getClassPk());
        clone.setAdjudication(getAdjudication());
        clone.setReason(getReason());
        clone.setNote(getNote());
        clone.setCreationDate(getCreationDate());
        clone.setCompletionDate(getCompletionDate());
        clone.setUserId(getUserId());

        return clone;
    }

    @Override
    public int compareTo(Waivr waivr) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), waivr.getCreationDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof WaivrClp)) {
            return false;
        }

        WaivrClp waivr = (WaivrClp) obj;

        long primaryKey = waivr.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{waivrId=");
        sb.append(getWaivrId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", adjudication=");
        sb.append(getAdjudication());
        sb.append(", reason=");
        sb.append(getReason());
        sb.append(", note=");
        sb.append(getNote());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", completionDate=");
        sb.append(getCompletionDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Waivr");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>waivrId</column-name><column-value><![CDATA[");
        sb.append(getWaivrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>adjudication</column-name><column-value><![CDATA[");
        sb.append(getAdjudication());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>reason</column-name><column-value><![CDATA[");
        sb.append(getReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>note</column-name><column-value><![CDATA[");
        sb.append(getNote());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionDate</column-name><column-value><![CDATA[");
        sb.append(getCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
