package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.VetVrLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class VetVrClp extends BaseModelImpl<VetVr> implements VetVr {
    private long _vetVrId;
    private long _vendrId;
    private long _cgId;
    private long _veteranId;
    private long _groupId;
    private BaseModel<?> _vetVrRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public VetVrClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return VetVr.class;
    }

    @Override
    public String getModelClassName() {
        return VetVr.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _vetVrId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVetVrId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vetVrId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vetVrId", getVetVrId());
        attributes.put("vendrId", getVendrId());
        attributes.put("cgId", getCgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vetVrId = (Long) attributes.get("vetVrId");

        if (vetVrId != null) {
            setVetVrId(vetVrId);
        }

        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        Long cgId = (Long) attributes.get("cgId");

        if (cgId != null) {
            setCgId(cgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVetVrId() {
        return _vetVrId;
    }

    @Override
    public void setVetVrId(long vetVrId) {
        _vetVrId = vetVrId;

        if (_vetVrRemoteModel != null) {
            try {
                Class<?> clazz = _vetVrRemoteModel.getClass();

                Method method = clazz.getMethod("setVetVrId", long.class);

                method.invoke(_vetVrRemoteModel, vetVrId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVendrId() {
        return _vendrId;
    }

    @Override
    public void setVendrId(long vendrId) {
        _vendrId = vendrId;

        if (_vetVrRemoteModel != null) {
            try {
                Class<?> clazz = _vetVrRemoteModel.getClass();

                Method method = clazz.getMethod("setVendrId", long.class);

                method.invoke(_vetVrRemoteModel, vendrId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCgId() {
        return _cgId;
    }

    @Override
    public void setCgId(long cgId) {
        _cgId = cgId;

        if (_vetVrRemoteModel != null) {
            try {
                Class<?> clazz = _vetVrRemoteModel.getClass();

                Method method = clazz.getMethod("setCgId", long.class);

                method.invoke(_vetVrRemoteModel, cgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVeteranId() {
        return _veteranId;
    }

    @Override
    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;

        if (_vetVrRemoteModel != null) {
            try {
                Class<?> clazz = _vetVrRemoteModel.getClass();

                Method method = clazz.getMethod("setVeteranId", long.class);

                method.invoke(_vetVrRemoteModel, veteranId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_vetVrRemoteModel != null) {
            try {
                Class<?> clazz = _vetVrRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_vetVrRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getVetVrRemoteModel() {
        return _vetVrRemoteModel;
    }

    public void setVetVrRemoteModel(BaseModel<?> vetVrRemoteModel) {
        _vetVrRemoteModel = vetVrRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _vetVrRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_vetVrRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VetVrLocalServiceUtil.addVetVr(this);
        } else {
            VetVrLocalServiceUtil.updateVetVr(this);
        }
    }

    @Override
    public VetVr toEscapedModel() {
        return (VetVr) ProxyUtil.newProxyInstance(VetVr.class.getClassLoader(),
            new Class[] { VetVr.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        VetVrClp clone = new VetVrClp();

        clone.setVetVrId(getVetVrId());
        clone.setVendrId(getVendrId());
        clone.setCgId(getCgId());
        clone.setVeteranId(getVeteranId());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(VetVr vetVr) {
        long primaryKey = vetVr.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VetVrClp)) {
            return false;
        }

        VetVrClp vetVr = (VetVrClp) obj;

        long primaryKey = vetVr.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{vetVrId=");
        sb.append(getVetVrId());
        sb.append(", vendrId=");
        sb.append(getVendrId());
        sb.append(", cgId=");
        sb.append(getCgId());
        sb.append(", veteranId=");
        sb.append(getVeteranId());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.VetVr");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vetVrId</column-name><column-value><![CDATA[");
        sb.append(getVetVrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vendrId</column-name><column-value><![CDATA[");
        sb.append(getVendrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cgId</column-name><column-value><![CDATA[");
        sb.append(getCgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranId</column-name><column-value><![CDATA[");
        sb.append(getVeteranId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
