package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link VcgAn}.
 * </p>
 *
 * @author caret
 * @see VcgAn
 * @generated
 */
public class VcgAnWrapper implements VcgAn, ModelWrapper<VcgAn> {
    private VcgAn _vcgAn;

    public VcgAnWrapper(VcgAn vcgAn) {
        _vcgAn = vcgAn;
    }

    @Override
    public Class<?> getModelClass() {
        return VcgAn.class;
    }

    @Override
    public String getModelClassName() {
        return VcgAn.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vcgAnId", getVcgAnId());
        attributes.put("vcgId", getVcgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("primaryId", getPrimaryId());
        attributes.put("secondaryId", getSecondaryId());
        attributes.put("secondaryTwoId", getSecondaryTwoId());
        attributes.put("status", getStatus());
        attributes.put("receivedDate", getReceivedDate());
        attributes.put("primaryRelationship", getPrimaryRelationship());
        attributes.put("secondaryRelationship", getSecondaryRelationship());
        attributes.put("secondaryTwoRelationship", getSecondaryTwoRelationship());
        attributes.put("primarySignDate", getPrimarySignDate());
        attributes.put("secondarySignDate", getSecondarySignDate());
        attributes.put("secondaryTwoSignDate", getSecondaryTwoSignDate());
        attributes.put("vaHealthEnrolled", getVaHealthEnrolled());
        attributes.put("mediEnrolled", getMediEnrolled());
        attributes.put("lastTreatmentPlace", getLastTreatmentPlace());
        attributes.put("hospital", getHospital());
        attributes.put("clinic", getClinic());
        attributes.put("submitDate", getSubmitDate());
        attributes.put("creationDate", getCreationDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vcgAnId = (Long) attributes.get("vcgAnId");

        if (vcgAnId != null) {
            setVcgAnId(vcgAnId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        Long primaryId = (Long) attributes.get("primaryId");

        if (primaryId != null) {
            setPrimaryId(primaryId);
        }

        Long secondaryId = (Long) attributes.get("secondaryId");

        if (secondaryId != null) {
            setSecondaryId(secondaryId);
        }

        Long secondaryTwoId = (Long) attributes.get("secondaryTwoId");

        if (secondaryTwoId != null) {
            setSecondaryTwoId(secondaryTwoId);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date receivedDate = (Date) attributes.get("receivedDate");

        if (receivedDate != null) {
            setReceivedDate(receivedDate);
        }

        String primaryRelationship = (String) attributes.get(
                "primaryRelationship");

        if (primaryRelationship != null) {
            setPrimaryRelationship(primaryRelationship);
        }

        String secondaryRelationship = (String) attributes.get(
                "secondaryRelationship");

        if (secondaryRelationship != null) {
            setSecondaryRelationship(secondaryRelationship);
        }

        String secondaryTwoRelationship = (String) attributes.get(
                "secondaryTwoRelationship");

        if (secondaryTwoRelationship != null) {
            setSecondaryTwoRelationship(secondaryTwoRelationship);
        }

        Date primarySignDate = (Date) attributes.get("primarySignDate");

        if (primarySignDate != null) {
            setPrimarySignDate(primarySignDate);
        }

        Date secondarySignDate = (Date) attributes.get("secondarySignDate");

        if (secondarySignDate != null) {
            setSecondarySignDate(secondarySignDate);
        }

        Date secondaryTwoSignDate = (Date) attributes.get(
                "secondaryTwoSignDate");

        if (secondaryTwoSignDate != null) {
            setSecondaryTwoSignDate(secondaryTwoSignDate);
        }

        Boolean vaHealthEnrolled = (Boolean) attributes.get("vaHealthEnrolled");

        if (vaHealthEnrolled != null) {
            setVaHealthEnrolled(vaHealthEnrolled);
        }

        Boolean mediEnrolled = (Boolean) attributes.get("mediEnrolled");

        if (mediEnrolled != null) {
            setMediEnrolled(mediEnrolled);
        }

        String lastTreatmentPlace = (String) attributes.get(
                "lastTreatmentPlace");

        if (lastTreatmentPlace != null) {
            setLastTreatmentPlace(lastTreatmentPlace);
        }

        Boolean hospital = (Boolean) attributes.get("hospital");

        if (hospital != null) {
            setHospital(hospital);
        }

        Boolean clinic = (Boolean) attributes.get("clinic");

        if (clinic != null) {
            setClinic(clinic);
        }

        Date submitDate = (Date) attributes.get("submitDate");

        if (submitDate != null) {
            setSubmitDate(submitDate);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    /**
    * Returns the primary key of this vcg an.
    *
    * @return the primary key of this vcg an
    */
    @Override
    public long getPrimaryKey() {
        return _vcgAn.getPrimaryKey();
    }

    /**
    * Sets the primary key of this vcg an.
    *
    * @param primaryKey the primary key of this vcg an
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _vcgAn.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the vcg an ID of this vcg an.
    *
    * @return the vcg an ID of this vcg an
    */
    @Override
    public long getVcgAnId() {
        return _vcgAn.getVcgAnId();
    }

    /**
    * Sets the vcg an ID of this vcg an.
    *
    * @param vcgAnId the vcg an ID of this vcg an
    */
    @Override
    public void setVcgAnId(long vcgAnId) {
        _vcgAn.setVcgAnId(vcgAnId);
    }

    /**
    * Returns the vcg ID of this vcg an.
    *
    * @return the vcg ID of this vcg an
    */
    @Override
    public long getVcgId() {
        return _vcgAn.getVcgId();
    }

    /**
    * Sets the vcg ID of this vcg an.
    *
    * @param vcgId the vcg ID of this vcg an
    */
    @Override
    public void setVcgId(long vcgId) {
        _vcgAn.setVcgId(vcgId);
    }

    /**
    * Returns the veteran ID of this vcg an.
    *
    * @return the veteran ID of this vcg an
    */
    @Override
    public long getVeteranId() {
        return _vcgAn.getVeteranId();
    }

    /**
    * Sets the veteran ID of this vcg an.
    *
    * @param veteranId the veteran ID of this vcg an
    */
    @Override
    public void setVeteranId(long veteranId) {
        _vcgAn.setVeteranId(veteranId);
    }

    /**
    * Returns the primary ID of this vcg an.
    *
    * @return the primary ID of this vcg an
    */
    @Override
    public long getPrimaryId() {
        return _vcgAn.getPrimaryId();
    }

    /**
    * Sets the primary ID of this vcg an.
    *
    * @param primaryId the primary ID of this vcg an
    */
    @Override
    public void setPrimaryId(long primaryId) {
        _vcgAn.setPrimaryId(primaryId);
    }

    /**
    * Returns the secondary ID of this vcg an.
    *
    * @return the secondary ID of this vcg an
    */
    @Override
    public long getSecondaryId() {
        return _vcgAn.getSecondaryId();
    }

    /**
    * Sets the secondary ID of this vcg an.
    *
    * @param secondaryId the secondary ID of this vcg an
    */
    @Override
    public void setSecondaryId(long secondaryId) {
        _vcgAn.setSecondaryId(secondaryId);
    }

    /**
    * Returns the secondary two ID of this vcg an.
    *
    * @return the secondary two ID of this vcg an
    */
    @Override
    public long getSecondaryTwoId() {
        return _vcgAn.getSecondaryTwoId();
    }

    /**
    * Sets the secondary two ID of this vcg an.
    *
    * @param secondaryTwoId the secondary two ID of this vcg an
    */
    @Override
    public void setSecondaryTwoId(long secondaryTwoId) {
        _vcgAn.setSecondaryTwoId(secondaryTwoId);
    }

    /**
    * Returns the status of this vcg an.
    *
    * @return the status of this vcg an
    */
    @Override
    public java.lang.String getStatus() {
        return _vcgAn.getStatus();
    }

    /**
    * Sets the status of this vcg an.
    *
    * @param status the status of this vcg an
    */
    @Override
    public void setStatus(java.lang.String status) {
        _vcgAn.setStatus(status);
    }

    /**
    * Returns the received date of this vcg an.
    *
    * @return the received date of this vcg an
    */
    @Override
    public java.util.Date getReceivedDate() {
        return _vcgAn.getReceivedDate();
    }

    /**
    * Sets the received date of this vcg an.
    *
    * @param receivedDate the received date of this vcg an
    */
    @Override
    public void setReceivedDate(java.util.Date receivedDate) {
        _vcgAn.setReceivedDate(receivedDate);
    }

    /**
    * Returns the primary relationship of this vcg an.
    *
    * @return the primary relationship of this vcg an
    */
    @Override
    public java.lang.String getPrimaryRelationship() {
        return _vcgAn.getPrimaryRelationship();
    }

    /**
    * Sets the primary relationship of this vcg an.
    *
    * @param primaryRelationship the primary relationship of this vcg an
    */
    @Override
    public void setPrimaryRelationship(java.lang.String primaryRelationship) {
        _vcgAn.setPrimaryRelationship(primaryRelationship);
    }

    /**
    * Returns the secondary relationship of this vcg an.
    *
    * @return the secondary relationship of this vcg an
    */
    @Override
    public java.lang.String getSecondaryRelationship() {
        return _vcgAn.getSecondaryRelationship();
    }

    /**
    * Sets the secondary relationship of this vcg an.
    *
    * @param secondaryRelationship the secondary relationship of this vcg an
    */
    @Override
    public void setSecondaryRelationship(java.lang.String secondaryRelationship) {
        _vcgAn.setSecondaryRelationship(secondaryRelationship);
    }

    /**
    * Returns the secondary two relationship of this vcg an.
    *
    * @return the secondary two relationship of this vcg an
    */
    @Override
    public java.lang.String getSecondaryTwoRelationship() {
        return _vcgAn.getSecondaryTwoRelationship();
    }

    /**
    * Sets the secondary two relationship of this vcg an.
    *
    * @param secondaryTwoRelationship the secondary two relationship of this vcg an
    */
    @Override
    public void setSecondaryTwoRelationship(
        java.lang.String secondaryTwoRelationship) {
        _vcgAn.setSecondaryTwoRelationship(secondaryTwoRelationship);
    }

    /**
    * Returns the primary sign date of this vcg an.
    *
    * @return the primary sign date of this vcg an
    */
    @Override
    public java.util.Date getPrimarySignDate() {
        return _vcgAn.getPrimarySignDate();
    }

    /**
    * Sets the primary sign date of this vcg an.
    *
    * @param primarySignDate the primary sign date of this vcg an
    */
    @Override
    public void setPrimarySignDate(java.util.Date primarySignDate) {
        _vcgAn.setPrimarySignDate(primarySignDate);
    }

    /**
    * Returns the secondary sign date of this vcg an.
    *
    * @return the secondary sign date of this vcg an
    */
    @Override
    public java.util.Date getSecondarySignDate() {
        return _vcgAn.getSecondarySignDate();
    }

    /**
    * Sets the secondary sign date of this vcg an.
    *
    * @param secondarySignDate the secondary sign date of this vcg an
    */
    @Override
    public void setSecondarySignDate(java.util.Date secondarySignDate) {
        _vcgAn.setSecondarySignDate(secondarySignDate);
    }

    /**
    * Returns the secondary two sign date of this vcg an.
    *
    * @return the secondary two sign date of this vcg an
    */
    @Override
    public java.util.Date getSecondaryTwoSignDate() {
        return _vcgAn.getSecondaryTwoSignDate();
    }

    /**
    * Sets the secondary two sign date of this vcg an.
    *
    * @param secondaryTwoSignDate the secondary two sign date of this vcg an
    */
    @Override
    public void setSecondaryTwoSignDate(java.util.Date secondaryTwoSignDate) {
        _vcgAn.setSecondaryTwoSignDate(secondaryTwoSignDate);
    }

    /**
    * Returns the va health enrolled of this vcg an.
    *
    * @return the va health enrolled of this vcg an
    */
    @Override
    public boolean getVaHealthEnrolled() {
        return _vcgAn.getVaHealthEnrolled();
    }

    /**
    * Returns <code>true</code> if this vcg an is va health enrolled.
    *
    * @return <code>true</code> if this vcg an is va health enrolled; <code>false</code> otherwise
    */
    @Override
    public boolean isVaHealthEnrolled() {
        return _vcgAn.isVaHealthEnrolled();
    }

    /**
    * Sets whether this vcg an is va health enrolled.
    *
    * @param vaHealthEnrolled the va health enrolled of this vcg an
    */
    @Override
    public void setVaHealthEnrolled(boolean vaHealthEnrolled) {
        _vcgAn.setVaHealthEnrolled(vaHealthEnrolled);
    }

    /**
    * Returns the medi enrolled of this vcg an.
    *
    * @return the medi enrolled of this vcg an
    */
    @Override
    public boolean getMediEnrolled() {
        return _vcgAn.getMediEnrolled();
    }

    /**
    * Returns <code>true</code> if this vcg an is medi enrolled.
    *
    * @return <code>true</code> if this vcg an is medi enrolled; <code>false</code> otherwise
    */
    @Override
    public boolean isMediEnrolled() {
        return _vcgAn.isMediEnrolled();
    }

    /**
    * Sets whether this vcg an is medi enrolled.
    *
    * @param mediEnrolled the medi enrolled of this vcg an
    */
    @Override
    public void setMediEnrolled(boolean mediEnrolled) {
        _vcgAn.setMediEnrolled(mediEnrolled);
    }

    /**
    * Returns the last treatment place of this vcg an.
    *
    * @return the last treatment place of this vcg an
    */
    @Override
    public java.lang.String getLastTreatmentPlace() {
        return _vcgAn.getLastTreatmentPlace();
    }

    /**
    * Sets the last treatment place of this vcg an.
    *
    * @param lastTreatmentPlace the last treatment place of this vcg an
    */
    @Override
    public void setLastTreatmentPlace(java.lang.String lastTreatmentPlace) {
        _vcgAn.setLastTreatmentPlace(lastTreatmentPlace);
    }

    /**
    * Returns the hospital of this vcg an.
    *
    * @return the hospital of this vcg an
    */
    @Override
    public boolean getHospital() {
        return _vcgAn.getHospital();
    }

    /**
    * Returns <code>true</code> if this vcg an is hospital.
    *
    * @return <code>true</code> if this vcg an is hospital; <code>false</code> otherwise
    */
    @Override
    public boolean isHospital() {
        return _vcgAn.isHospital();
    }

    /**
    * Sets whether this vcg an is hospital.
    *
    * @param hospital the hospital of this vcg an
    */
    @Override
    public void setHospital(boolean hospital) {
        _vcgAn.setHospital(hospital);
    }

    /**
    * Returns the clinic of this vcg an.
    *
    * @return the clinic of this vcg an
    */
    @Override
    public boolean getClinic() {
        return _vcgAn.getClinic();
    }

    /**
    * Returns <code>true</code> if this vcg an is clinic.
    *
    * @return <code>true</code> if this vcg an is clinic; <code>false</code> otherwise
    */
    @Override
    public boolean isClinic() {
        return _vcgAn.isClinic();
    }

    /**
    * Sets whether this vcg an is clinic.
    *
    * @param clinic the clinic of this vcg an
    */
    @Override
    public void setClinic(boolean clinic) {
        _vcgAn.setClinic(clinic);
    }

    /**
    * Returns the submit date of this vcg an.
    *
    * @return the submit date of this vcg an
    */
    @Override
    public java.util.Date getSubmitDate() {
        return _vcgAn.getSubmitDate();
    }

    /**
    * Sets the submit date of this vcg an.
    *
    * @param submitDate the submit date of this vcg an
    */
    @Override
    public void setSubmitDate(java.util.Date submitDate) {
        _vcgAn.setSubmitDate(submitDate);
    }

    /**
    * Returns the creation date of this vcg an.
    *
    * @return the creation date of this vcg an
    */
    @Override
    public java.util.Date getCreationDate() {
        return _vcgAn.getCreationDate();
    }

    /**
    * Sets the creation date of this vcg an.
    *
    * @param creationDate the creation date of this vcg an
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _vcgAn.setCreationDate(creationDate);
    }

    /**
    * Returns the group ID of this vcg an.
    *
    * @return the group ID of this vcg an
    */
    @Override
    public long getGroupId() {
        return _vcgAn.getGroupId();
    }

    /**
    * Sets the group ID of this vcg an.
    *
    * @param groupId the group ID of this vcg an
    */
    @Override
    public void setGroupId(long groupId) {
        _vcgAn.setGroupId(groupId);
    }

    @Override
    public boolean isNew() {
        return _vcgAn.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _vcgAn.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _vcgAn.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _vcgAn.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _vcgAn.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _vcgAn.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _vcgAn.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _vcgAn.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _vcgAn.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _vcgAn.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _vcgAn.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new VcgAnWrapper((VcgAn) _vcgAn.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.VcgAn vcgAn) {
        return _vcgAn.compareTo(vcgAn);
    }

    @Override
    public int hashCode() {
        return _vcgAn.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.VcgAn> toCacheModel() {
        return _vcgAn.toCacheModel();
    }

    @Override
    public gov.va.caret.model.VcgAn toEscapedModel() {
        return new VcgAnWrapper(_vcgAn.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.VcgAn toUnescapedModel() {
        return new VcgAnWrapper(_vcgAn.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _vcgAn.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _vcgAn.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _vcgAn.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VcgAnWrapper)) {
            return false;
        }

        VcgAnWrapper vcgAnWrapper = (VcgAnWrapper) obj;

        if (Validator.equals(_vcgAn, vcgAnWrapper._vcgAn)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public VcgAn getWrappedVcgAn() {
        return _vcgAn;
    }

    @Override
    public VcgAn getWrappedModel() {
        return _vcgAn;
    }

    @Override
    public void resetOriginalValues() {
        _vcgAn.resetOriginalValues();
    }
}
