package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the VcgAn service. Represents a row in the &quot;CARET_APPLICATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.VcgAnModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.VcgAnImpl}.
 * </p>
 *
 * @author caret
 * @see VcgAn
 * @see gov.va.caret.model.impl.VcgAnImpl
 * @see gov.va.caret.model.impl.VcgAnModelImpl
 * @generated
 */
public interface VcgAnModel extends BaseModel<VcgAn> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a vcg an model instance should use the {@link VcgAn} interface instead.
     */

    /**
     * Returns the primary key of this vcg an.
     *
     * @return the primary key of this vcg an
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this vcg an.
     *
     * @param primaryKey the primary key of this vcg an
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the vcg an ID of this vcg an.
     *
     * @return the vcg an ID of this vcg an
     */
    public long getVcgAnId();

    /**
     * Sets the vcg an ID of this vcg an.
     *
     * @param vcgAnId the vcg an ID of this vcg an
     */
    public void setVcgAnId(long vcgAnId);

    /**
     * Returns the vcg ID of this vcg an.
     *
     * @return the vcg ID of this vcg an
     */
    public long getVcgId();

    /**
     * Sets the vcg ID of this vcg an.
     *
     * @param vcgId the vcg ID of this vcg an
     */
    public void setVcgId(long vcgId);

    /**
     * Returns the veteran ID of this vcg an.
     *
     * @return the veteran ID of this vcg an
     */
    public long getVeteranId();

    /**
     * Sets the veteran ID of this vcg an.
     *
     * @param veteranId the veteran ID of this vcg an
     */
    public void setVeteranId(long veteranId);

    /**
     * Returns the primary ID of this vcg an.
     *
     * @return the primary ID of this vcg an
     */
    public long getPrimaryId();

    /**
     * Sets the primary ID of this vcg an.
     *
     * @param primaryId the primary ID of this vcg an
     */
    public void setPrimaryId(long primaryId);

    /**
     * Returns the secondary ID of this vcg an.
     *
     * @return the secondary ID of this vcg an
     */
    public long getSecondaryId();

    /**
     * Sets the secondary ID of this vcg an.
     *
     * @param secondaryId the secondary ID of this vcg an
     */
    public void setSecondaryId(long secondaryId);

    /**
     * Returns the secondary two ID of this vcg an.
     *
     * @return the secondary two ID of this vcg an
     */
    public long getSecondaryTwoId();

    /**
     * Sets the secondary two ID of this vcg an.
     *
     * @param secondaryTwoId the secondary two ID of this vcg an
     */
    public void setSecondaryTwoId(long secondaryTwoId);

    /**
     * Returns the status of this vcg an.
     *
     * @return the status of this vcg an
     */
    @AutoEscape
    public String getStatus();

    /**
     * Sets the status of this vcg an.
     *
     * @param status the status of this vcg an
     */
    public void setStatus(String status);

    /**
     * Returns the received date of this vcg an.
     *
     * @return the received date of this vcg an
     */
    public Date getReceivedDate();

    /**
     * Sets the received date of this vcg an.
     *
     * @param receivedDate the received date of this vcg an
     */
    public void setReceivedDate(Date receivedDate);

    /**
     * Returns the primary relationship of this vcg an.
     *
     * @return the primary relationship of this vcg an
     */
    @AutoEscape
    public String getPrimaryRelationship();

    /**
     * Sets the primary relationship of this vcg an.
     *
     * @param primaryRelationship the primary relationship of this vcg an
     */
    public void setPrimaryRelationship(String primaryRelationship);

    /**
     * Returns the secondary relationship of this vcg an.
     *
     * @return the secondary relationship of this vcg an
     */
    @AutoEscape
    public String getSecondaryRelationship();

    /**
     * Sets the secondary relationship of this vcg an.
     *
     * @param secondaryRelationship the secondary relationship of this vcg an
     */
    public void setSecondaryRelationship(String secondaryRelationship);

    /**
     * Returns the secondary two relationship of this vcg an.
     *
     * @return the secondary two relationship of this vcg an
     */
    @AutoEscape
    public String getSecondaryTwoRelationship();

    /**
     * Sets the secondary two relationship of this vcg an.
     *
     * @param secondaryTwoRelationship the secondary two relationship of this vcg an
     */
    public void setSecondaryTwoRelationship(String secondaryTwoRelationship);

    /**
     * Returns the primary sign date of this vcg an.
     *
     * @return the primary sign date of this vcg an
     */
    public Date getPrimarySignDate();

    /**
     * Sets the primary sign date of this vcg an.
     *
     * @param primarySignDate the primary sign date of this vcg an
     */
    public void setPrimarySignDate(Date primarySignDate);

    /**
     * Returns the secondary sign date of this vcg an.
     *
     * @return the secondary sign date of this vcg an
     */
    public Date getSecondarySignDate();

    /**
     * Sets the secondary sign date of this vcg an.
     *
     * @param secondarySignDate the secondary sign date of this vcg an
     */
    public void setSecondarySignDate(Date secondarySignDate);

    /**
     * Returns the secondary two sign date of this vcg an.
     *
     * @return the secondary two sign date of this vcg an
     */
    public Date getSecondaryTwoSignDate();

    /**
     * Sets the secondary two sign date of this vcg an.
     *
     * @param secondaryTwoSignDate the secondary two sign date of this vcg an
     */
    public void setSecondaryTwoSignDate(Date secondaryTwoSignDate);

    /**
     * Returns the va health enrolled of this vcg an.
     *
     * @return the va health enrolled of this vcg an
     */
    public boolean getVaHealthEnrolled();

    /**
     * Returns <code>true</code> if this vcg an is va health enrolled.
     *
     * @return <code>true</code> if this vcg an is va health enrolled; <code>false</code> otherwise
     */
    public boolean isVaHealthEnrolled();

    /**
     * Sets whether this vcg an is va health enrolled.
     *
     * @param vaHealthEnrolled the va health enrolled of this vcg an
     */
    public void setVaHealthEnrolled(boolean vaHealthEnrolled);

    /**
     * Returns the medi enrolled of this vcg an.
     *
     * @return the medi enrolled of this vcg an
     */
    public boolean getMediEnrolled();

    /**
     * Returns <code>true</code> if this vcg an is medi enrolled.
     *
     * @return <code>true</code> if this vcg an is medi enrolled; <code>false</code> otherwise
     */
    public boolean isMediEnrolled();

    /**
     * Sets whether this vcg an is medi enrolled.
     *
     * @param mediEnrolled the medi enrolled of this vcg an
     */
    public void setMediEnrolled(boolean mediEnrolled);

    /**
     * Returns the last treatment place of this vcg an.
     *
     * @return the last treatment place of this vcg an
     */
    @AutoEscape
    public String getLastTreatmentPlace();

    /**
     * Sets the last treatment place of this vcg an.
     *
     * @param lastTreatmentPlace the last treatment place of this vcg an
     */
    public void setLastTreatmentPlace(String lastTreatmentPlace);

    /**
     * Returns the hospital of this vcg an.
     *
     * @return the hospital of this vcg an
     */
    public boolean getHospital();

    /**
     * Returns <code>true</code> if this vcg an is hospital.
     *
     * @return <code>true</code> if this vcg an is hospital; <code>false</code> otherwise
     */
    public boolean isHospital();

    /**
     * Sets whether this vcg an is hospital.
     *
     * @param hospital the hospital of this vcg an
     */
    public void setHospital(boolean hospital);

    /**
     * Returns the clinic of this vcg an.
     *
     * @return the clinic of this vcg an
     */
    public boolean getClinic();

    /**
     * Returns <code>true</code> if this vcg an is clinic.
     *
     * @return <code>true</code> if this vcg an is clinic; <code>false</code> otherwise
     */
    public boolean isClinic();

    /**
     * Sets whether this vcg an is clinic.
     *
     * @param clinic the clinic of this vcg an
     */
    public void setClinic(boolean clinic);

    /**
     * Returns the submit date of this vcg an.
     *
     * @return the submit date of this vcg an
     */
    public Date getSubmitDate();

    /**
     * Sets the submit date of this vcg an.
     *
     * @param submitDate the submit date of this vcg an
     */
    public void setSubmitDate(Date submitDate);

    /**
     * Returns the creation date of this vcg an.
     *
     * @return the creation date of this vcg an
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this vcg an.
     *
     * @param creationDate the creation date of this vcg an
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the group ID of this vcg an.
     *
     * @return the group ID of this vcg an
     */
    public long getGroupId();

    /**
     * Sets the group ID of this vcg an.
     *
     * @param groupId the group ID of this vcg an
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.VcgAn vcgAn);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.VcgAn> toCacheModel();

    @Override
    public gov.va.caret.model.VcgAn toEscapedModel();

    @Override
    public gov.va.caret.model.VcgAn toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
