package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.VcgAnLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class VcgAnClp extends BaseModelImpl<VcgAn> implements VcgAn {
    private long _vcgAnId;
    private long _vcgId;
    private long _veteranId;
    private long _primaryId;
    private long _secondaryId;
    private long _secondaryTwoId;
    private String _status;
    private Date _receivedDate;
    private String _primaryRelationship;
    private String _secondaryRelationship;
    private String _secondaryTwoRelationship;
    private Date _primarySignDate;
    private Date _secondarySignDate;
    private Date _secondaryTwoSignDate;
    private boolean _vaHealthEnrolled;
    private boolean _mediEnrolled;
    private String _lastTreatmentPlace;
    private boolean _hospital;
    private boolean _clinic;
    private Date _submitDate;
    private Date _creationDate;
    private long _groupId;
    private BaseModel<?> _vcgAnRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public VcgAnClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return VcgAn.class;
    }

    @Override
    public String getModelClassName() {
        return VcgAn.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _vcgAnId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVcgAnId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vcgAnId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vcgAnId", getVcgAnId());
        attributes.put("vcgId", getVcgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("primaryId", getPrimaryId());
        attributes.put("secondaryId", getSecondaryId());
        attributes.put("secondaryTwoId", getSecondaryTwoId());
        attributes.put("status", getStatus());
        attributes.put("receivedDate", getReceivedDate());
        attributes.put("primaryRelationship", getPrimaryRelationship());
        attributes.put("secondaryRelationship", getSecondaryRelationship());
        attributes.put("secondaryTwoRelationship", getSecondaryTwoRelationship());
        attributes.put("primarySignDate", getPrimarySignDate());
        attributes.put("secondarySignDate", getSecondarySignDate());
        attributes.put("secondaryTwoSignDate", getSecondaryTwoSignDate());
        attributes.put("vaHealthEnrolled", getVaHealthEnrolled());
        attributes.put("mediEnrolled", getMediEnrolled());
        attributes.put("lastTreatmentPlace", getLastTreatmentPlace());
        attributes.put("hospital", getHospital());
        attributes.put("clinic", getClinic());
        attributes.put("submitDate", getSubmitDate());
        attributes.put("creationDate", getCreationDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vcgAnId = (Long) attributes.get("vcgAnId");

        if (vcgAnId != null) {
            setVcgAnId(vcgAnId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        Long primaryId = (Long) attributes.get("primaryId");

        if (primaryId != null) {
            setPrimaryId(primaryId);
        }

        Long secondaryId = (Long) attributes.get("secondaryId");

        if (secondaryId != null) {
            setSecondaryId(secondaryId);
        }

        Long secondaryTwoId = (Long) attributes.get("secondaryTwoId");

        if (secondaryTwoId != null) {
            setSecondaryTwoId(secondaryTwoId);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date receivedDate = (Date) attributes.get("receivedDate");

        if (receivedDate != null) {
            setReceivedDate(receivedDate);
        }

        String primaryRelationship = (String) attributes.get(
                "primaryRelationship");

        if (primaryRelationship != null) {
            setPrimaryRelationship(primaryRelationship);
        }

        String secondaryRelationship = (String) attributes.get(
                "secondaryRelationship");

        if (secondaryRelationship != null) {
            setSecondaryRelationship(secondaryRelationship);
        }

        String secondaryTwoRelationship = (String) attributes.get(
                "secondaryTwoRelationship");

        if (secondaryTwoRelationship != null) {
            setSecondaryTwoRelationship(secondaryTwoRelationship);
        }

        Date primarySignDate = (Date) attributes.get("primarySignDate");

        if (primarySignDate != null) {
            setPrimarySignDate(primarySignDate);
        }

        Date secondarySignDate = (Date) attributes.get("secondarySignDate");

        if (secondarySignDate != null) {
            setSecondarySignDate(secondarySignDate);
        }

        Date secondaryTwoSignDate = (Date) attributes.get(
                "secondaryTwoSignDate");

        if (secondaryTwoSignDate != null) {
            setSecondaryTwoSignDate(secondaryTwoSignDate);
        }

        Boolean vaHealthEnrolled = (Boolean) attributes.get("vaHealthEnrolled");

        if (vaHealthEnrolled != null) {
            setVaHealthEnrolled(vaHealthEnrolled);
        }

        Boolean mediEnrolled = (Boolean) attributes.get("mediEnrolled");

        if (mediEnrolled != null) {
            setMediEnrolled(mediEnrolled);
        }

        String lastTreatmentPlace = (String) attributes.get(
                "lastTreatmentPlace");

        if (lastTreatmentPlace != null) {
            setLastTreatmentPlace(lastTreatmentPlace);
        }

        Boolean hospital = (Boolean) attributes.get("hospital");

        if (hospital != null) {
            setHospital(hospital);
        }

        Boolean clinic = (Boolean) attributes.get("clinic");

        if (clinic != null) {
            setClinic(clinic);
        }

        Date submitDate = (Date) attributes.get("submitDate");

        if (submitDate != null) {
            setSubmitDate(submitDate);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVcgAnId() {
        return _vcgAnId;
    }

    @Override
    public void setVcgAnId(long vcgAnId) {
        _vcgAnId = vcgAnId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setVcgAnId", long.class);

                method.invoke(_vcgAnRemoteModel, vcgAnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _vcgId = vcgId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setVcgId", long.class);

                method.invoke(_vcgAnRemoteModel, vcgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVeteranId() {
        return _veteranId;
    }

    @Override
    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setVeteranId", long.class);

                method.invoke(_vcgAnRemoteModel, veteranId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getPrimaryId() {
        return _primaryId;
    }

    @Override
    public void setPrimaryId(long primaryId) {
        _primaryId = primaryId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryId", long.class);

                method.invoke(_vcgAnRemoteModel, primaryId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getSecondaryId() {
        return _secondaryId;
    }

    @Override
    public void setSecondaryId(long secondaryId) {
        _secondaryId = secondaryId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryId", long.class);

                method.invoke(_vcgAnRemoteModel, secondaryId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getSecondaryTwoId() {
        return _secondaryTwoId;
    }

    @Override
    public void setSecondaryTwoId(long secondaryTwoId) {
        _secondaryTwoId = secondaryTwoId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoId", long.class);

                method.invoke(_vcgAnRemoteModel, secondaryTwoId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStatus() {
        return _status;
    }

    @Override
    public void setStatus(String status) {
        _status = status;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setStatus", String.class);

                method.invoke(_vcgAnRemoteModel, status);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getReceivedDate() {
        return _receivedDate;
    }

    @Override
    public void setReceivedDate(Date receivedDate) {
        _receivedDate = receivedDate;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setReceivedDate", Date.class);

                method.invoke(_vcgAnRemoteModel, receivedDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPrimaryRelationship() {
        return _primaryRelationship;
    }

    @Override
    public void setPrimaryRelationship(String primaryRelationship) {
        _primaryRelationship = primaryRelationship;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryRelationship",
                        String.class);

                method.invoke(_vcgAnRemoteModel, primaryRelationship);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSecondaryRelationship() {
        return _secondaryRelationship;
    }

    @Override
    public void setSecondaryRelationship(String secondaryRelationship) {
        _secondaryRelationship = secondaryRelationship;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryRelationship",
                        String.class);

                method.invoke(_vcgAnRemoteModel, secondaryRelationship);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSecondaryTwoRelationship() {
        return _secondaryTwoRelationship;
    }

    @Override
    public void setSecondaryTwoRelationship(String secondaryTwoRelationship) {
        _secondaryTwoRelationship = secondaryTwoRelationship;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoRelationship",
                        String.class);

                method.invoke(_vcgAnRemoteModel, secondaryTwoRelationship);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getPrimarySignDate() {
        return _primarySignDate;
    }

    @Override
    public void setPrimarySignDate(Date primarySignDate) {
        _primarySignDate = primarySignDate;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimarySignDate", Date.class);

                method.invoke(_vcgAnRemoteModel, primarySignDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSecondarySignDate() {
        return _secondarySignDate;
    }

    @Override
    public void setSecondarySignDate(Date secondarySignDate) {
        _secondarySignDate = secondarySignDate;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondarySignDate",
                        Date.class);

                method.invoke(_vcgAnRemoteModel, secondarySignDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSecondaryTwoSignDate() {
        return _secondaryTwoSignDate;
    }

    @Override
    public void setSecondaryTwoSignDate(Date secondaryTwoSignDate) {
        _secondaryTwoSignDate = secondaryTwoSignDate;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoSignDate",
                        Date.class);

                method.invoke(_vcgAnRemoteModel, secondaryTwoSignDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getVaHealthEnrolled() {
        return _vaHealthEnrolled;
    }

    @Override
    public boolean isVaHealthEnrolled() {
        return _vaHealthEnrolled;
    }

    @Override
    public void setVaHealthEnrolled(boolean vaHealthEnrolled) {
        _vaHealthEnrolled = vaHealthEnrolled;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setVaHealthEnrolled",
                        boolean.class);

                method.invoke(_vcgAnRemoteModel, vaHealthEnrolled);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getMediEnrolled() {
        return _mediEnrolled;
    }

    @Override
    public boolean isMediEnrolled() {
        return _mediEnrolled;
    }

    @Override
    public void setMediEnrolled(boolean mediEnrolled) {
        _mediEnrolled = mediEnrolled;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setMediEnrolled", boolean.class);

                method.invoke(_vcgAnRemoteModel, mediEnrolled);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLastTreatmentPlace() {
        return _lastTreatmentPlace;
    }

    @Override
    public void setLastTreatmentPlace(String lastTreatmentPlace) {
        _lastTreatmentPlace = lastTreatmentPlace;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setLastTreatmentPlace",
                        String.class);

                method.invoke(_vcgAnRemoteModel, lastTreatmentPlace);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getHospital() {
        return _hospital;
    }

    @Override
    public boolean isHospital() {
        return _hospital;
    }

    @Override
    public void setHospital(boolean hospital) {
        _hospital = hospital;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setHospital", boolean.class);

                method.invoke(_vcgAnRemoteModel, hospital);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getClinic() {
        return _clinic;
    }

    @Override
    public boolean isClinic() {
        return _clinic;
    }

    @Override
    public void setClinic(boolean clinic) {
        _clinic = clinic;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setClinic", boolean.class);

                method.invoke(_vcgAnRemoteModel, clinic);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSubmitDate() {
        return _submitDate;
    }

    @Override
    public void setSubmitDate(Date submitDate) {
        _submitDate = submitDate;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setSubmitDate", Date.class);

                method.invoke(_vcgAnRemoteModel, submitDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_vcgAnRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_vcgAnRemoteModel != null) {
            try {
                Class<?> clazz = _vcgAnRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_vcgAnRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getVcgAnRemoteModel() {
        return _vcgAnRemoteModel;
    }

    public void setVcgAnRemoteModel(BaseModel<?> vcgAnRemoteModel) {
        _vcgAnRemoteModel = vcgAnRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _vcgAnRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_vcgAnRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VcgAnLocalServiceUtil.addVcgAn(this);
        } else {
            VcgAnLocalServiceUtil.updateVcgAn(this);
        }
    }

    @Override
    public VcgAn toEscapedModel() {
        return (VcgAn) ProxyUtil.newProxyInstance(VcgAn.class.getClassLoader(),
            new Class[] { VcgAn.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        VcgAnClp clone = new VcgAnClp();

        clone.setVcgAnId(getVcgAnId());
        clone.setVcgId(getVcgId());
        clone.setVeteranId(getVeteranId());
        clone.setPrimaryId(getPrimaryId());
        clone.setSecondaryId(getSecondaryId());
        clone.setSecondaryTwoId(getSecondaryTwoId());
        clone.setStatus(getStatus());
        clone.setReceivedDate(getReceivedDate());
        clone.setPrimaryRelationship(getPrimaryRelationship());
        clone.setSecondaryRelationship(getSecondaryRelationship());
        clone.setSecondaryTwoRelationship(getSecondaryTwoRelationship());
        clone.setPrimarySignDate(getPrimarySignDate());
        clone.setSecondarySignDate(getSecondarySignDate());
        clone.setSecondaryTwoSignDate(getSecondaryTwoSignDate());
        clone.setVaHealthEnrolled(getVaHealthEnrolled());
        clone.setMediEnrolled(getMediEnrolled());
        clone.setLastTreatmentPlace(getLastTreatmentPlace());
        clone.setHospital(getHospital());
        clone.setClinic(getClinic());
        clone.setSubmitDate(getSubmitDate());
        clone.setCreationDate(getCreationDate());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(VcgAn vcgAn) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), vcgAn.getCreationDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VcgAnClp)) {
            return false;
        }

        VcgAnClp vcgAn = (VcgAnClp) obj;

        long primaryKey = vcgAn.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(45);

        sb.append("{vcgAnId=");
        sb.append(getVcgAnId());
        sb.append(", vcgId=");
        sb.append(getVcgId());
        sb.append(", veteranId=");
        sb.append(getVeteranId());
        sb.append(", primaryId=");
        sb.append(getPrimaryId());
        sb.append(", secondaryId=");
        sb.append(getSecondaryId());
        sb.append(", secondaryTwoId=");
        sb.append(getSecondaryTwoId());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", receivedDate=");
        sb.append(getReceivedDate());
        sb.append(", primaryRelationship=");
        sb.append(getPrimaryRelationship());
        sb.append(", secondaryRelationship=");
        sb.append(getSecondaryRelationship());
        sb.append(", secondaryTwoRelationship=");
        sb.append(getSecondaryTwoRelationship());
        sb.append(", primarySignDate=");
        sb.append(getPrimarySignDate());
        sb.append(", secondarySignDate=");
        sb.append(getSecondarySignDate());
        sb.append(", secondaryTwoSignDate=");
        sb.append(getSecondaryTwoSignDate());
        sb.append(", vaHealthEnrolled=");
        sb.append(getVaHealthEnrolled());
        sb.append(", mediEnrolled=");
        sb.append(getMediEnrolled());
        sb.append(", lastTreatmentPlace=");
        sb.append(getLastTreatmentPlace());
        sb.append(", hospital=");
        sb.append(getHospital());
        sb.append(", clinic=");
        sb.append(getClinic());
        sb.append(", submitDate=");
        sb.append(getSubmitDate());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(70);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.VcgAn");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vcgAnId</column-name><column-value><![CDATA[");
        sb.append(getVcgAnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranId</column-name><column-value><![CDATA[");
        sb.append(getVeteranId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryId</column-name><column-value><![CDATA[");
        sb.append(getPrimaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>receivedDate</column-name><column-value><![CDATA[");
        sb.append(getReceivedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryRelationship</column-name><column-value><![CDATA[");
        sb.append(getPrimaryRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryRelationship</column-name><column-value><![CDATA[");
        sb.append(getSecondaryRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoRelationship</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primarySignDate</column-name><column-value><![CDATA[");
        sb.append(getPrimarySignDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondarySignDate</column-name><column-value><![CDATA[");
        sb.append(getSecondarySignDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoSignDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoSignDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vaHealthEnrolled</column-name><column-value><![CDATA[");
        sb.append(getVaHealthEnrolled());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>mediEnrolled</column-name><column-value><![CDATA[");
        sb.append(getMediEnrolled());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>lastTreatmentPlace</column-name><column-value><![CDATA[");
        sb.append(getLastTreatmentPlace());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>hospital</column-name><column-value><![CDATA[");
        sb.append(getHospital());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>clinic</column-name><column-value><![CDATA[");
        sb.append(getClinic());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>submitDate</column-name><column-value><![CDATA[");
        sb.append(getSubmitDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
