package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class PayLgSoap implements Serializable {
    private long _paymentLogId;
    private long _stiPtId;
    private Double _amount;
    private Date _paymentDate;
    private String _status;
    private String _reason;
    private Date _creationDate;
    private long _userId;

    public PayLgSoap() {
    }

    public static PayLgSoap toSoapModel(PayLg model) {
        PayLgSoap soapModel = new PayLgSoap();

        soapModel.setPaymentLogId(model.getPaymentLogId());
        soapModel.setStiPtId(model.getStiPtId());
        soapModel.setAmount(model.getAmount());
        soapModel.setPaymentDate(model.getPaymentDate());
        soapModel.setStatus(model.getStatus());
        soapModel.setReason(model.getReason());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setUserId(model.getUserId());

        return soapModel;
    }

    public static PayLgSoap[] toSoapModels(PayLg[] models) {
        PayLgSoap[] soapModels = new PayLgSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static PayLgSoap[][] toSoapModels(PayLg[][] models) {
        PayLgSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new PayLgSoap[models.length][models[0].length];
        } else {
            soapModels = new PayLgSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static PayLgSoap[] toSoapModels(List<PayLg> models) {
        List<PayLgSoap> soapModels = new ArrayList<PayLgSoap>(models.size());

        for (PayLg model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new PayLgSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _paymentLogId;
    }

    public void setPrimaryKey(long pk) {
        setPaymentLogId(pk);
    }

    public long getPaymentLogId() {
        return _paymentLogId;
    }

    public void setPaymentLogId(long paymentLogId) {
        _paymentLogId = paymentLogId;
    }

    public long getStiPtId() {
        return _stiPtId;
    }

    public void setStiPtId(long stiPtId) {
        _stiPtId = stiPtId;
    }

    public Double getAmount() {
        return _amount;
    }

    public void setAmount(Double amount) {
        _amount = amount;
    }

    public Date getPaymentDate() {
        return _paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        _paymentDate = paymentDate;
    }

    public String getStatus() {
        return _status;
    }

    public void setStatus(String status) {
        _status = status;
    }

    public String getReason() {
        return _reason;
    }

    public void setReason(String reason) {
        _reason = reason;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }
}
