package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.PayLgLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class PayLgClp extends BaseModelImpl<PayLg> implements PayLg {
    private long _paymentLogId;
    private long _stiPtId;
    private Double _amount;
    private Date _paymentDate;
    private String _status;
    private String _reason;
    private Date _creationDate;
    private long _userId;
    private String _userUuid;
    private BaseModel<?> _payLgRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public PayLgClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return PayLg.class;
    }

    @Override
    public String getModelClassName() {
        return PayLg.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _paymentLogId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setPaymentLogId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _paymentLogId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("paymentLogId", getPaymentLogId());
        attributes.put("stiPtId", getStiPtId());
        attributes.put("amount", getAmount());
        attributes.put("paymentDate", getPaymentDate());
        attributes.put("status", getStatus());
        attributes.put("reason", getReason());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long paymentLogId = (Long) attributes.get("paymentLogId");

        if (paymentLogId != null) {
            setPaymentLogId(paymentLogId);
        }

        Long stiPtId = (Long) attributes.get("stiPtId");

        if (stiPtId != null) {
            setStiPtId(stiPtId);
        }

        Double amount = (Double) attributes.get("amount");

        if (amount != null) {
            setAmount(amount);
        }

        Date paymentDate = (Date) attributes.get("paymentDate");

        if (paymentDate != null) {
            setPaymentDate(paymentDate);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String reason = (String) attributes.get("reason");

        if (reason != null) {
            setReason(reason);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    @Override
    public long getPaymentLogId() {
        return _paymentLogId;
    }

    @Override
    public void setPaymentLogId(long paymentLogId) {
        _paymentLogId = paymentLogId;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setPaymentLogId", long.class);

                method.invoke(_payLgRemoteModel, paymentLogId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getStiPtId() {
        return _stiPtId;
    }

    @Override
    public void setStiPtId(long stiPtId) {
        _stiPtId = stiPtId;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setStiPtId", long.class);

                method.invoke(_payLgRemoteModel, stiPtId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Double getAmount() {
        return _amount;
    }

    @Override
    public void setAmount(Double amount) {
        _amount = amount;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setAmount", Double.class);

                method.invoke(_payLgRemoteModel, amount);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getPaymentDate() {
        return _paymentDate;
    }

    @Override
    public void setPaymentDate(Date paymentDate) {
        _paymentDate = paymentDate;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setPaymentDate", Date.class);

                method.invoke(_payLgRemoteModel, paymentDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStatus() {
        return _status;
    }

    @Override
    public void setStatus(String status) {
        _status = status;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setStatus", String.class);

                method.invoke(_payLgRemoteModel, status);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getReason() {
        return _reason;
    }

    @Override
    public void setReason(String reason) {
        _reason = reason;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setReason", String.class);

                method.invoke(_payLgRemoteModel, reason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_payLgRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_payLgRemoteModel != null) {
            try {
                Class<?> clazz = _payLgRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_payLgRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public BaseModel<?> getPayLgRemoteModel() {
        return _payLgRemoteModel;
    }

    public void setPayLgRemoteModel(BaseModel<?> payLgRemoteModel) {
        _payLgRemoteModel = payLgRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _payLgRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_payLgRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PayLgLocalServiceUtil.addPayLg(this);
        } else {
            PayLgLocalServiceUtil.updatePayLg(this);
        }
    }

    @Override
    public PayLg toEscapedModel() {
        return (PayLg) ProxyUtil.newProxyInstance(PayLg.class.getClassLoader(),
            new Class[] { PayLg.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        PayLgClp clone = new PayLgClp();

        clone.setPaymentLogId(getPaymentLogId());
        clone.setStiPtId(getStiPtId());
        clone.setAmount(getAmount());
        clone.setPaymentDate(getPaymentDate());
        clone.setStatus(getStatus());
        clone.setReason(getReason());
        clone.setCreationDate(getCreationDate());
        clone.setUserId(getUserId());

        return clone;
    }

    @Override
    public int compareTo(PayLg payLg) {
        int value = 0;

        value = DateUtil.compareTo(getPaymentDate(), payLg.getPaymentDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PayLgClp)) {
            return false;
        }

        PayLgClp payLg = (PayLgClp) obj;

        long primaryKey = payLg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{paymentLogId=");
        sb.append(getPaymentLogId());
        sb.append(", stiPtId=");
        sb.append(getStiPtId());
        sb.append(", amount=");
        sb.append(getAmount());
        sb.append(", paymentDate=");
        sb.append(getPaymentDate());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", reason=");
        sb.append(getReason());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.PayLg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>paymentLogId</column-name><column-value><![CDATA[");
        sb.append(getPaymentLogId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stiPtId</column-name><column-value><![CDATA[");
        sb.append(getStiPtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>amount</column-name><column-value><![CDATA[");
        sb.append(getAmount());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>paymentDate</column-name><column-value><![CDATA[");
        sb.append(getPaymentDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>reason</column-name><column-value><![CDATA[");
        sb.append(getReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
