/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class PMReadMessageSoap implements Serializable {
	public static PMReadMessageSoap toSoapModel(PMReadMessage model) {
		PMReadMessageSoap soapModel = new PMReadMessageSoap();

		soapModel.setReadMessageId(model.getReadMessageId());
		soapModel.setMessageId(model.getMessageId());
		soapModel.setReadDate(model.getReadDate());

		return soapModel;
	}

	public static PMReadMessageSoap[] toSoapModels(PMReadMessage[] models) {
		PMReadMessageSoap[] soapModels = new PMReadMessageSoap[models.length];

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModel(models[i]);
		}

		return soapModels;
	}

	public static PMReadMessageSoap[][] toSoapModels(PMReadMessage[][] models) {
		PMReadMessageSoap[][] soapModels = null;

		if (models.length > 0) {
			soapModels = new PMReadMessageSoap[models.length][models[0].length];
		}
		else {
			soapModels = new PMReadMessageSoap[0][0];
		}

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModels(models[i]);
		}

		return soapModels;
	}

	public static PMReadMessageSoap[] toSoapModels(List<PMReadMessage> models) {
		List<PMReadMessageSoap> soapModels = new ArrayList<PMReadMessageSoap>(models.size());

		for (PMReadMessage model : models) {
			soapModels.add(toSoapModel(model));
		}

		return soapModels.toArray(new PMReadMessageSoap[soapModels.size()]);
	}

	public PMReadMessageSoap() {
	}

	public long getPrimaryKey() {
		return _readMessageId;
	}

	public void setPrimaryKey(long pk) {
		setReadMessageId(pk);
	}

	public long getReadMessageId() {
		return _readMessageId;
	}

	public void setReadMessageId(long readMessageId) {
		_readMessageId = readMessageId;
	}

	public long getMessageId() {
		return _messageId;
	}

	public void setMessageId(long messageId) {
		_messageId = messageId;
	}

	public Date getReadDate() {
		return _readDate;
	}

	public void setReadDate(Date readDate) {
		_readDate = readDate;
	}

	private long _readMessageId;
	private long _messageId;
	private Date _readDate;
}