/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class PMMessageSoap implements Serializable {
	public static PMMessageSoap toSoapModel(PMMessage model) {
		PMMessageSoap soapModel = new PMMessageSoap();

		soapModel.setMessageId(model.getMessageId());
		soapModel.setSubject(model.getSubject());
		soapModel.setBody(model.getBody());
		soapModel.setUrl(model.getUrl());
		soapModel.setParentMessageId(model.getParentMessageId());
		soapModel.setOwnerId(model.getOwnerId());
		soapModel.setOwnerName(model.getOwnerName());
		soapModel.setPostedDate(model.getPostedDate());
		soapModel.setRecepients(model.getRecepients());

		return soapModel;
	}

	public static PMMessageSoap[] toSoapModels(PMMessage[] models) {
		PMMessageSoap[] soapModels = new PMMessageSoap[models.length];

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModel(models[i]);
		}

		return soapModels;
	}

	public static PMMessageSoap[][] toSoapModels(PMMessage[][] models) {
		PMMessageSoap[][] soapModels = null;

		if (models.length > 0) {
			soapModels = new PMMessageSoap[models.length][models[0].length];
		}
		else {
			soapModels = new PMMessageSoap[0][0];
		}

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModels(models[i]);
		}

		return soapModels;
	}

	public static PMMessageSoap[] toSoapModels(List<PMMessage> models) {
		List<PMMessageSoap> soapModels = new ArrayList<PMMessageSoap>(models.size());

		for (PMMessage model : models) {
			soapModels.add(toSoapModel(model));
		}

		return soapModels.toArray(new PMMessageSoap[soapModels.size()]);
	}

	public PMMessageSoap() {
	}

	public long getPrimaryKey() {
		return _messageId;
	}

	public void setPrimaryKey(long pk) {
		setMessageId(pk);
	}

	public long getMessageId() {
		return _messageId;
	}

	public void setMessageId(long messageId) {
		_messageId = messageId;
	}

	public String getSubject() {
		return _subject;
	}

	public void setSubject(String subject) {
		_subject = subject;
	}

	public String getBody() {
		return _body;
	}

	public void setBody(String body) {
		_body = body;
	}

	public String getUrl() {
		return _url;
	}

	public void setUrl(String url) {
		_url = url;
	}

	public long getParentMessageId() {
		return _parentMessageId;
	}

	public void setParentMessageId(long parentMessageId) {
		_parentMessageId = parentMessageId;
	}

	public long getOwnerId() {
		return _ownerId;
	}

	public void setOwnerId(long ownerId) {
		_ownerId = ownerId;
	}

	public String getOwnerName() {
		return _ownerName;
	}

	public void setOwnerName(String ownerName) {
		_ownerName = ownerName;
	}

	public Date getPostedDate() {
		return _postedDate;
	}

	public void setPostedDate(Date postedDate) {
		_postedDate = postedDate;
	}

	public String getRecepients() {
		return _recepients;
	}

	public void setRecepients(String recepients) {
		_recepients = recepients;
	}

	private long _messageId;
	private String _subject;
	private String _body;
	private String _url;
	private long _parentMessageId;
	private long _ownerId;
	private String _ownerName;
	private Date _postedDate;
	private String _recepients;
}