package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Note service. Represents a row in the &quot;CARET_NOTE&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.NoteModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.NoteImpl}.
 * </p>
 *
 * @author caret
 * @see Note
 * @see gov.va.caret.model.impl.NoteImpl
 * @see gov.va.caret.model.impl.NoteModelImpl
 * @generated
 */
public interface NoteModel extends BaseModel<Note> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a note model instance should use the {@link Note} interface instead.
     */

    /**
     * Returns the primary key of this note.
     *
     * @return the primary key of this note
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this note.
     *
     * @param primaryKey the primary key of this note
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the uuid of this note.
     *
     * @return the uuid of this note
     */
    @AutoEscape
    public String getUuid();

    /**
     * Sets the uuid of this note.
     *
     * @param uuid the uuid of this note
     */
    public void setUuid(String uuid);

    /**
     * Returns the note ID of this note.
     *
     * @return the note ID of this note
     */
    public long getNoteId();

    /**
     * Sets the note ID of this note.
     *
     * @param noteId the note ID of this note
     */
    public void setNoteId(long noteId);

    /**
     * Returns the value of this note.
     *
     * @return the value of this note
     */
    @AutoEscape
    public String getValue();

    /**
     * Sets the value of this note.
     *
     * @param value the value of this note
     */
    public void setValue(String value);

    /**
     * Returns the user ID of this note.
     *
     * @return the user ID of this note
     */
    public long getUserId();

    /**
     * Sets the user ID of this note.
     *
     * @param userId the user ID of this note
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this note.
     *
     * @return the user uuid of this note
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this note.
     *
     * @param userUuid the user uuid of this note
     */
    public void setUserUuid(String userUuid);

    /**
     * Returns the creation date of this note.
     *
     * @return the creation date of this note
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this note.
     *
     * @param creationDate the creation date of this note
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the group ID of this note.
     *
     * @return the group ID of this note
     */
    public long getGroupId();

    /**
     * Sets the group ID of this note.
     *
     * @param groupId the group ID of this note
     */
    public void setGroupId(long groupId);

    /**
     * Returns the chain ID of this note.
     *
     * @return the chain ID of this note
     */
    public long getChainId();

    /**
     * Sets the chain ID of this note.
     *
     * @param chainId the chain ID of this note
     */
    public void setChainId(long chainId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Note note);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Note> toCacheModel();

    @Override
    public gov.va.caret.model.Note toEscapedModel();

    @Override
    public gov.va.caret.model.Note toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
