package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the EERatedDisability service. Represents a row in the &quot;CARET_EE_RATED_DISAB&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.EERatedDisabilityImpl}.
 * </p>
 *
 * @author caret
 * @see EERatedDisability
 * @see gov.va.caret.model.impl.EERatedDisabilityImpl
 * @see gov.va.caret.model.impl.EERatedDisabilityModelImpl
 * @generated
 */
public interface EERatedDisabilityModel extends BaseModel<EERatedDisability> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a e e rated disability model instance should use the {@link EERatedDisability} interface instead.
     */

    /**
     * Returns the primary key of this e e rated disability.
     *
     * @return the primary key of this e e rated disability
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this e e rated disability.
     *
     * @param primaryKey the primary key of this e e rated disability
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the ee rated disab ID of this e e rated disability.
     *
     * @return the ee rated disab ID of this e e rated disability
     */
    public long getEeRatedDisabId();

    /**
     * Sets the ee rated disab ID of this e e rated disability.
     *
     * @param eeRatedDisabId the ee rated disab ID of this e e rated disability
     */
    public void setEeRatedDisabId(long eeRatedDisabId);

    /**
     * Returns the ee lg ID of this e e rated disability.
     *
     * @return the ee lg ID of this e e rated disability
     */
    public long getEeLgId();

    /**
     * Sets the ee lg ID of this e e rated disability.
     *
     * @param eeLgId the ee lg ID of this e e rated disability
     */
    public void setEeLgId(long eeLgId);

    /**
     * Returns the percentage of this e e rated disability.
     *
     * @return the percentage of this e e rated disability
     */
    public long getPercentage();

    /**
     * Sets the percentage of this e e rated disability.
     *
     * @param percentage the percentage of this e e rated disability
     */
    public void setPercentage(long percentage);

    /**
     * Returns the code of this e e rated disability.
     *
     * @return the code of this e e rated disability
     */
    @AutoEscape
    public String getCode();

    /**
     * Sets the code of this e e rated disability.
     *
     * @param code the code of this e e rated disability
     */
    public void setCode(String code);

    /**
     * Returns the description of this e e rated disability.
     *
     * @return the description of this e e rated disability
     */
    @AutoEscape
    public String getDescription();

    /**
     * Sets the description of this e e rated disability.
     *
     * @param description the description of this e e rated disability
     */
    public void setDescription(String description);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.EERatedDisability eeRatedDisability);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.EERatedDisability> toCacheModel();

    @Override
    public gov.va.caret.model.EERatedDisability toEscapedModel();

    @Override
    public gov.va.caret.model.EERatedDisability toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
