package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link EEMonetaryBenefit}.
 * </p>
 *
 * @author caret
 * @see EEMonetaryBenefit
 * @generated
 */
public class EEMonetaryBenefitWrapper implements EEMonetaryBenefit,
    ModelWrapper<EEMonetaryBenefit> {
    private EEMonetaryBenefit _eeMonetaryBenefit;

    public EEMonetaryBenefitWrapper(EEMonetaryBenefit eeMonetaryBenefit) {
        _eeMonetaryBenefit = eeMonetaryBenefit;
    }

    @Override
    public Class<?> getModelClass() {
        return EEMonetaryBenefit.class;
    }

    @Override
    public String getModelClassName() {
        return EEMonetaryBenefit.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("eeMonBenefitId", getEeMonBenefitId());
        attributes.put("eeLgId", getEeLgId());
        attributes.put("monetaryBenefit", getMonetaryBenefit());
        attributes.put("type", getType());
        attributes.put("reportDate", getReportDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long eeMonBenefitId = (Long) attributes.get("eeMonBenefitId");

        if (eeMonBenefitId != null) {
            setEeMonBenefitId(eeMonBenefitId);
        }

        Long eeLgId = (Long) attributes.get("eeLgId");

        if (eeLgId != null) {
            setEeLgId(eeLgId);
        }

        String monetaryBenefit = (String) attributes.get("monetaryBenefit");

        if (monetaryBenefit != null) {
            setMonetaryBenefit(monetaryBenefit);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date reportDate = (Date) attributes.get("reportDate");

        if (reportDate != null) {
            setReportDate(reportDate);
        }
    }

    /**
    * Returns the primary key of this e e monetary benefit.
    *
    * @return the primary key of this e e monetary benefit
    */
    @Override
    public long getPrimaryKey() {
        return _eeMonetaryBenefit.getPrimaryKey();
    }

    /**
    * Sets the primary key of this e e monetary benefit.
    *
    * @param primaryKey the primary key of this e e monetary benefit
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _eeMonetaryBenefit.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the ee mon benefit ID of this e e monetary benefit.
    *
    * @return the ee mon benefit ID of this e e monetary benefit
    */
    @Override
    public long getEeMonBenefitId() {
        return _eeMonetaryBenefit.getEeMonBenefitId();
    }

    /**
    * Sets the ee mon benefit ID of this e e monetary benefit.
    *
    * @param eeMonBenefitId the ee mon benefit ID of this e e monetary benefit
    */
    @Override
    public void setEeMonBenefitId(long eeMonBenefitId) {
        _eeMonetaryBenefit.setEeMonBenefitId(eeMonBenefitId);
    }

    /**
    * Returns the ee lg ID of this e e monetary benefit.
    *
    * @return the ee lg ID of this e e monetary benefit
    */
    @Override
    public long getEeLgId() {
        return _eeMonetaryBenefit.getEeLgId();
    }

    /**
    * Sets the ee lg ID of this e e monetary benefit.
    *
    * @param eeLgId the ee lg ID of this e e monetary benefit
    */
    @Override
    public void setEeLgId(long eeLgId) {
        _eeMonetaryBenefit.setEeLgId(eeLgId);
    }

    /**
    * Returns the monetary benefit of this e e monetary benefit.
    *
    * @return the monetary benefit of this e e monetary benefit
    */
    @Override
    public java.lang.String getMonetaryBenefit() {
        return _eeMonetaryBenefit.getMonetaryBenefit();
    }

    /**
    * Sets the monetary benefit of this e e monetary benefit.
    *
    * @param monetaryBenefit the monetary benefit of this e e monetary benefit
    */
    @Override
    public void setMonetaryBenefit(java.lang.String monetaryBenefit) {
        _eeMonetaryBenefit.setMonetaryBenefit(monetaryBenefit);
    }

    /**
    * Returns the type of this e e monetary benefit.
    *
    * @return the type of this e e monetary benefit
    */
    @Override
    public java.lang.String getType() {
        return _eeMonetaryBenefit.getType();
    }

    /**
    * Sets the type of this e e monetary benefit.
    *
    * @param type the type of this e e monetary benefit
    */
    @Override
    public void setType(java.lang.String type) {
        _eeMonetaryBenefit.setType(type);
    }

    /**
    * Returns the report date of this e e monetary benefit.
    *
    * @return the report date of this e e monetary benefit
    */
    @Override
    public java.util.Date getReportDate() {
        return _eeMonetaryBenefit.getReportDate();
    }

    /**
    * Sets the report date of this e e monetary benefit.
    *
    * @param reportDate the report date of this e e monetary benefit
    */
    @Override
    public void setReportDate(java.util.Date reportDate) {
        _eeMonetaryBenefit.setReportDate(reportDate);
    }

    @Override
    public boolean isNew() {
        return _eeMonetaryBenefit.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _eeMonetaryBenefit.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _eeMonetaryBenefit.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _eeMonetaryBenefit.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _eeMonetaryBenefit.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _eeMonetaryBenefit.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _eeMonetaryBenefit.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _eeMonetaryBenefit.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _eeMonetaryBenefit.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _eeMonetaryBenefit.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _eeMonetaryBenefit.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new EEMonetaryBenefitWrapper((EEMonetaryBenefit) _eeMonetaryBenefit.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.EEMonetaryBenefit eeMonetaryBenefit) {
        return _eeMonetaryBenefit.compareTo(eeMonetaryBenefit);
    }

    @Override
    public int hashCode() {
        return _eeMonetaryBenefit.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.EEMonetaryBenefit> toCacheModel() {
        return _eeMonetaryBenefit.toCacheModel();
    }

    @Override
    public gov.va.caret.model.EEMonetaryBenefit toEscapedModel() {
        return new EEMonetaryBenefitWrapper(_eeMonetaryBenefit.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.EEMonetaryBenefit toUnescapedModel() {
        return new EEMonetaryBenefitWrapper(_eeMonetaryBenefit.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _eeMonetaryBenefit.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _eeMonetaryBenefit.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _eeMonetaryBenefit.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof EEMonetaryBenefitWrapper)) {
            return false;
        }

        EEMonetaryBenefitWrapper eeMonetaryBenefitWrapper = (EEMonetaryBenefitWrapper) obj;

        if (Validator.equals(_eeMonetaryBenefit,
                    eeMonetaryBenefitWrapper._eeMonetaryBenefit)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public EEMonetaryBenefit getWrappedEEMonetaryBenefit() {
        return _eeMonetaryBenefit;
    }

    @Override
    public EEMonetaryBenefit getWrappedModel() {
        return _eeMonetaryBenefit;
    }

    @Override
    public void resetOriginalValues() {
        _eeMonetaryBenefit.resetOriginalValues();
    }
}
