package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class EEMilitaryRecordSoap implements Serializable {
    private long _eeMilRecordId;
    private long _eeLgId;
    private String _serviceBranch;
    private Date _serviceDate;
    private Date _exitServiceDate;
    private String _dischargeType;

    public EEMilitaryRecordSoap() {
    }

    public static EEMilitaryRecordSoap toSoapModel(EEMilitaryRecord model) {
        EEMilitaryRecordSoap soapModel = new EEMilitaryRecordSoap();

        soapModel.setEeMilRecordId(model.getEeMilRecordId());
        soapModel.setEeLgId(model.getEeLgId());
        soapModel.setServiceBranch(model.getServiceBranch());
        soapModel.setServiceDate(model.getServiceDate());
        soapModel.setExitServiceDate(model.getExitServiceDate());
        soapModel.setDischargeType(model.getDischargeType());

        return soapModel;
    }

    public static EEMilitaryRecordSoap[] toSoapModels(EEMilitaryRecord[] models) {
        EEMilitaryRecordSoap[] soapModels = new EEMilitaryRecordSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static EEMilitaryRecordSoap[][] toSoapModels(
        EEMilitaryRecord[][] models) {
        EEMilitaryRecordSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new EEMilitaryRecordSoap[models.length][models[0].length];
        } else {
            soapModels = new EEMilitaryRecordSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static EEMilitaryRecordSoap[] toSoapModels(
        List<EEMilitaryRecord> models) {
        List<EEMilitaryRecordSoap> soapModels = new ArrayList<EEMilitaryRecordSoap>(models.size());

        for (EEMilitaryRecord model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new EEMilitaryRecordSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _eeMilRecordId;
    }

    public void setPrimaryKey(long pk) {
        setEeMilRecordId(pk);
    }

    public long getEeMilRecordId() {
        return _eeMilRecordId;
    }

    public void setEeMilRecordId(long eeMilRecordId) {
        _eeMilRecordId = eeMilRecordId;
    }

    public long getEeLgId() {
        return _eeLgId;
    }

    public void setEeLgId(long eeLgId) {
        _eeLgId = eeLgId;
    }

    public String getServiceBranch() {
        return _serviceBranch;
    }

    public void setServiceBranch(String serviceBranch) {
        _serviceBranch = serviceBranch;
    }

    public Date getServiceDate() {
        return _serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        _serviceDate = serviceDate;
    }

    public Date getExitServiceDate() {
        return _exitServiceDate;
    }

    public void setExitServiceDate(Date exitServiceDate) {
        _exitServiceDate = exitServiceDate;
    }

    public String getDischargeType() {
        return _dischargeType;
    }

    public void setDischargeType(String dischargeType) {
        _dischargeType = dischargeType;
    }
}
