package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class CryptoSoap implements Serializable {
    private long _cryptoId;
    private long _ownerId;
    private String _type;
    private String _value;
    private int _hcode;

    public CryptoSoap() {
    }

    public static CryptoSoap toSoapModel(Crypto model) {
        CryptoSoap soapModel = new CryptoSoap();

        soapModel.setCryptoId(model.getCryptoId());
        soapModel.setOwnerId(model.getOwnerId());
        soapModel.setType(model.getType());
        soapModel.setValue(model.getValue());
        soapModel.setHcode(model.getHcode());

        return soapModel;
    }

    public static CryptoSoap[] toSoapModels(Crypto[] models) {
        CryptoSoap[] soapModels = new CryptoSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static CryptoSoap[][] toSoapModels(Crypto[][] models) {
        CryptoSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new CryptoSoap[models.length][models[0].length];
        } else {
            soapModels = new CryptoSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static CryptoSoap[] toSoapModels(List<Crypto> models) {
        List<CryptoSoap> soapModels = new ArrayList<CryptoSoap>(models.size());

        for (Crypto model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new CryptoSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _cryptoId;
    }

    public void setPrimaryKey(long pk) {
        setCryptoId(pk);
    }

    public long getCryptoId() {
        return _cryptoId;
    }

    public void setCryptoId(long cryptoId) {
        _cryptoId = cryptoId;
    }

    public long getOwnerId() {
        return _ownerId;
    }

    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;
    }

    public String getType() {
        return _type;
    }

    public void setType(String type) {
        _type = type;
    }

    public String getValue() {
        return _value;
    }

    public void setValue(String value) {
        _value = value;
    }

    public int getHcode() {
        return _hcode;
    }

    public void setHcode(int hcode) {
        _hcode = hcode;
    }
}
