package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the Crypto service. Represents a row in the &quot;CARET_CRYPTO_VALUES&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.CryptoModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.CryptoImpl}.
 * </p>
 *
 * @author caret
 * @see Crypto
 * @see gov.va.caret.model.impl.CryptoImpl
 * @see gov.va.caret.model.impl.CryptoModelImpl
 * @generated
 */
public interface CryptoModel extends BaseModel<Crypto> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a crypto model instance should use the {@link Crypto} interface instead.
     */

    /**
     * Returns the primary key of this crypto.
     *
     * @return the primary key of this crypto
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this crypto.
     *
     * @param primaryKey the primary key of this crypto
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the crypto ID of this crypto.
     *
     * @return the crypto ID of this crypto
     */
    public long getCryptoId();

    /**
     * Sets the crypto ID of this crypto.
     *
     * @param cryptoId the crypto ID of this crypto
     */
    public void setCryptoId(long cryptoId);

    /**
     * Returns the owner ID of this crypto.
     *
     * @return the owner ID of this crypto
     */
    public long getOwnerId();

    /**
     * Sets the owner ID of this crypto.
     *
     * @param ownerId the owner ID of this crypto
     */
    public void setOwnerId(long ownerId);

    /**
     * Returns the type of this crypto.
     *
     * @return the type of this crypto
     */
    @AutoEscape
    public String getType();

    /**
     * Sets the type of this crypto.
     *
     * @param type the type of this crypto
     */
    public void setType(String type);

    /**
     * Returns the value of this crypto.
     *
     * @return the value of this crypto
     */
    @AutoEscape
    public String getValue();

    /**
     * Sets the value of this crypto.
     *
     * @param value the value of this crypto
     */
    public void setValue(String value);

    /**
     * Returns the hcode of this crypto.
     *
     * @return the hcode of this crypto
     */
    public int getHcode();

    /**
     * Sets the hcode of this crypto.
     *
     * @param hcode the hcode of this crypto
     */
    public void setHcode(int hcode);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Crypto crypto);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Crypto> toCacheModel();

    @Override
    public gov.va.caret.model.Crypto toEscapedModel();

    @Override
    public gov.va.caret.model.Crypto toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
