package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link CalEt}.
 * </p>
 *
 * @author caret
 * @see CalEt
 * @generated
 */
public class CalEtWrapper implements CalEt, ModelWrapper<CalEt> {
    private CalEt _calEt;

    public CalEtWrapper(CalEt calEt) {
        _calEt = calEt;
    }

    @Override
    public Class<?> getModelClass() {
        return CalEt.class;
    }

    @Override
    public String getModelClassName() {
        return CalEt.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("calEtId", getCalEtId());
        attributes.put("callId", getCallId());
        attributes.put("event", getEvent());
        attributes.put("comment", getComment());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long calEtId = (Long) attributes.get("calEtId");

        if (calEtId != null) {
            setCalEtId(calEtId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        String event = (String) attributes.get("event");

        if (event != null) {
            setEvent(event);
        }

        String comment = (String) attributes.get("comment");

        if (comment != null) {
            setComment(comment);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    /**
    * Returns the primary key of this cal et.
    *
    * @return the primary key of this cal et
    */
    @Override
    public long getPrimaryKey() {
        return _calEt.getPrimaryKey();
    }

    /**
    * Sets the primary key of this cal et.
    *
    * @param primaryKey the primary key of this cal et
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _calEt.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the cal et ID of this cal et.
    *
    * @return the cal et ID of this cal et
    */
    @Override
    public long getCalEtId() {
        return _calEt.getCalEtId();
    }

    /**
    * Sets the cal et ID of this cal et.
    *
    * @param calEtId the cal et ID of this cal et
    */
    @Override
    public void setCalEtId(long calEtId) {
        _calEt.setCalEtId(calEtId);
    }

    /**
    * Returns the call ID of this cal et.
    *
    * @return the call ID of this cal et
    */
    @Override
    public long getCallId() {
        return _calEt.getCallId();
    }

    /**
    * Sets the call ID of this cal et.
    *
    * @param callId the call ID of this cal et
    */
    @Override
    public void setCallId(long callId) {
        _calEt.setCallId(callId);
    }

    /**
    * Returns the event of this cal et.
    *
    * @return the event of this cal et
    */
    @Override
    public java.lang.String getEvent() {
        return _calEt.getEvent();
    }

    /**
    * Sets the event of this cal et.
    *
    * @param event the event of this cal et
    */
    @Override
    public void setEvent(java.lang.String event) {
        _calEt.setEvent(event);
    }

    /**
    * Returns the comment of this cal et.
    *
    * @return the comment of this cal et
    */
    @Override
    public java.lang.String getComment() {
        return _calEt.getComment();
    }

    /**
    * Sets the comment of this cal et.
    *
    * @param comment the comment of this cal et
    */
    @Override
    public void setComment(java.lang.String comment) {
        _calEt.setComment(comment);
    }

    /**
    * Returns the creation date of this cal et.
    *
    * @return the creation date of this cal et
    */
    @Override
    public java.util.Date getCreationDate() {
        return _calEt.getCreationDate();
    }

    /**
    * Sets the creation date of this cal et.
    *
    * @param creationDate the creation date of this cal et
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _calEt.setCreationDate(creationDate);
    }

    /**
    * Returns the user ID of this cal et.
    *
    * @return the user ID of this cal et
    */
    @Override
    public long getUserId() {
        return _calEt.getUserId();
    }

    /**
    * Sets the user ID of this cal et.
    *
    * @param userId the user ID of this cal et
    */
    @Override
    public void setUserId(long userId) {
        _calEt.setUserId(userId);
    }

    /**
    * Returns the user uuid of this cal et.
    *
    * @return the user uuid of this cal et
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.lang.String getUserUuid()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _calEt.getUserUuid();
    }

    /**
    * Sets the user uuid of this cal et.
    *
    * @param userUuid the user uuid of this cal et
    */
    @Override
    public void setUserUuid(java.lang.String userUuid) {
        _calEt.setUserUuid(userUuid);
    }

    @Override
    public boolean isNew() {
        return _calEt.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _calEt.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _calEt.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _calEt.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _calEt.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _calEt.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _calEt.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _calEt.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _calEt.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _calEt.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _calEt.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new CalEtWrapper((CalEt) _calEt.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.CalEt calEt) {
        return _calEt.compareTo(calEt);
    }

    @Override
    public int hashCode() {
        return _calEt.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.CalEt> toCacheModel() {
        return _calEt.toCacheModel();
    }

    @Override
    public gov.va.caret.model.CalEt toEscapedModel() {
        return new CalEtWrapper(_calEt.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.CalEt toUnescapedModel() {
        return new CalEtWrapper(_calEt.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _calEt.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _calEt.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _calEt.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CalEtWrapper)) {
            return false;
        }

        CalEtWrapper calEtWrapper = (CalEtWrapper) obj;

        if (Validator.equals(_calEt, calEtWrapper._calEt)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public CalEt getWrappedCalEt() {
        return _calEt;
    }

    @Override
    public CalEt getWrappedModel() {
        return _calEt;
    }

    @Override
    public void resetOriginalValues() {
        _calEt.resetOriginalValues();
    }
}
